# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include keyspaces_service.R
NULL

#' The CreateKeyspace operation adds a new keyspace to your account
#'
#' @description
#' The [`create_keyspace`][keyspaces_create_keyspace] operation adds a new keyspace to your account. In an Amazon Web Services account, keyspace names must be unique within each Region.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_create_keyspace/](https://www.paws-r-sdk.com/docs/keyspaces_create_keyspace/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace to be created.
#' @param tags A list of key-value pair tags to be attached to the keyspace.
#' 
#' For more information, see [Adding tags and labels to Amazon Keyspaces
#' resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param replicationSpecification The replication specification of the keyspace includes:
#' 
#' -   `replicationStrategy` - the required value is `SINGLE_REGION` or
#'     `MULTI_REGION`.
#' 
#' -   `regionList` - if the `replicationStrategy` is `MULTI_REGION`, the
#'     `regionList` requires the current Region and at least one additional
#'     Amazon Web Services Region where the keyspace is going to be
#'     replicated in. The maximum number of supported replication Regions
#'     including the current Region is six.
#'
#' @keywords internal
#'
#' @rdname keyspaces_create_keyspace
keyspaces_create_keyspace <- function(keyspaceName, tags = NULL, replicationSpecification = NULL) {
  op <- new_operation(
    name = "CreateKeyspace",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$create_keyspace_input(keyspaceName = keyspaceName, tags = tags, replicationSpecification = replicationSpecification)
  output <- .keyspaces$create_keyspace_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$create_keyspace <- keyspaces_create_keyspace

#' The CreateTable operation adds a new table to the specified keyspace
#'
#' @description
#' The [`create_table`][keyspaces_create_table] operation adds a new table to the specified keyspace. Within a keyspace, table names must be unique.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_create_table/](https://www.paws-r-sdk.com/docs/keyspaces_create_table/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace that the table is going to be created in.
#' @param tableName &#91;required&#93; The name of the table.
#' @param schemaDefinition &#91;required&#93; The `schemaDefinition` consists of the following parameters.
#' 
#' For each column to be created:
#' 
#' -   `name` - The name of the column.
#' 
#' -   `type` - An Amazon Keyspaces data type. For more information, see
#'     [Data
#'     types](https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types)
#'     in the *Amazon Keyspaces Developer Guide*.
#' 
#' The primary key of the table consists of the following columns:
#' 
#' -   `partitionKeys` - The partition key can be a single column, or it
#'     can be a compound value composed of two or more columns. The
#'     partition key portion of the primary key is required and determines
#'     how Amazon Keyspaces stores your data.
#' 
#' -   `name` - The name of each partition key column.
#' 
#' -   `clusteringKeys` - The optional clustering column portion of your
#'     primary key determines how the data is clustered and sorted within
#'     each partition.
#' 
#' -   `name` - The name of the clustering column.
#' 
#' -   `orderBy` - Sets the ascendant (`ASC`) or descendant (`DESC`) order
#'     modifier.
#' 
#'     To define a column as static use `staticColumns` - Static columns
#'     store values that are shared by all rows in the same partition:
#' 
#' -   `name` - The name of the column.
#' 
#' -   `type` - An Amazon Keyspaces data type.
#' @param comment This parameter allows to enter a description of the table.
#' @param capacitySpecification Specifies the read/write throughput capacity mode for the table. The
#' options are:
#' 
#' -   `throughputMode:PAY_PER_REQUEST` and
#' 
#' -   `throughputMode:PROVISIONED` - Provisioned capacity mode requires
#'     `readCapacityUnits` and `writeCapacityUnits` as input.
#' 
#' The default is `throughput_mode:PAY_PER_REQUEST`.
#' 
#' For more information, see [Read/write capacity
#' modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param encryptionSpecification Specifies how the encryption key for encryption at rest is managed for
#' the table. You can choose one of the following KMS key (KMS key):
#' 
#' -   `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
#' 
#' -   `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account
#'     and is created, owned, and managed by you. This option requires the
#'     `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN)
#'     format as input.
#' 
#' The default is `type:AWS_OWNED_KMS_KEY`.
#' 
#' For more information, see [Encryption at
#' rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param pointInTimeRecovery Specifies if `pointInTimeRecovery` is enabled or disabled for the table.
#' The options are:
#' 
#' -   `status=ENABLED`
#' 
#' -   `status=DISABLED`
#' 
#' If it's not specified, the default is `status=DISABLED`.
#' 
#' For more information, see [Point-in-time
#' recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param ttl Enables Time to Live custom settings for the table. The options are:
#' 
#' -   `status:enabled`
#' 
#' -   `status:disabled`
#' 
#' The default is `status:disabled`. After `ttl` is enabled, you can't
#' disable it for the table.
#' 
#' For more information, see [Expiring data by using Amazon Keyspaces Time
#' to Live
#' (TTL)](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param defaultTimeToLive The default Time to Live setting in seconds for the table.
#' 
#' For more information, see [Setting the default TTL value for a
#' table](https://docs.aws.amazon.com/keyspaces/latest/devguide/#ttl-howitworks_default_ttl)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param tags A list of key-value pair tags to be attached to the resource.
#' 
#' For more information, see [Adding tags and labels to Amazon Keyspaces
#' resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param clientSideTimestamps Enables client-side timestamps for the table. By default, the setting is
#' disabled. You can enable client-side timestamps with the following
#' option:
#' 
#' -   `status: "enabled"`
#' 
#' Once client-side timestamps are enabled for a table, this setting cannot
#' be disabled.
#' @param autoScalingSpecification The optional auto scaling settings for a table in provisioned capacity
#' mode. Specifies if the service can manage throughput capacity
#' automatically on your behalf.
#' 
#' Auto scaling helps you provision throughput capacity for variable
#' workloads efficiently by increasing and decreasing your table's read and
#' write capacity automatically in response to application traffic. For
#' more information, see [Managing throughput capacity automatically with
#' Amazon Keyspaces auto
#' scaling](https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' 
#' By default, auto scaling is disabled for a table.
#' @param replicaSpecifications The optional Amazon Web Services Region specific settings of a
#' multi-Region table. These settings overwrite the general settings of the
#' table for the specified Region.
#' 
#' For a multi-Region table in provisioned capacity mode, you can configure
#' the table's read capacity differently for each Region's replica. The
#' write capacity, however, remains synchronized between all replicas to
#' ensure that there's enough capacity to replicate writes across all
#' Regions. To define the read capacity for a table replica in a specific
#' Region, you can do so by configuring the following parameters.
#' 
#' -   `region`: The Region where these settings are applied. (Required)
#' 
#' -   `readCapacityUnits`: The provisioned read capacity units. (Optional)
#' 
#' -   `readCapacityAutoScaling`: The read capacity auto scaling settings
#'     for the table. (Optional)
#'
#' @keywords internal
#'
#' @rdname keyspaces_create_table
keyspaces_create_table <- function(keyspaceName, tableName, schemaDefinition, comment = NULL, capacitySpecification = NULL, encryptionSpecification = NULL, pointInTimeRecovery = NULL, ttl = NULL, defaultTimeToLive = NULL, tags = NULL, clientSideTimestamps = NULL, autoScalingSpecification = NULL, replicaSpecifications = NULL) {
  op <- new_operation(
    name = "CreateTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$create_table_input(keyspaceName = keyspaceName, tableName = tableName, schemaDefinition = schemaDefinition, comment = comment, capacitySpecification = capacitySpecification, encryptionSpecification = encryptionSpecification, pointInTimeRecovery = pointInTimeRecovery, ttl = ttl, defaultTimeToLive = defaultTimeToLive, tags = tags, clientSideTimestamps = clientSideTimestamps, autoScalingSpecification = autoScalingSpecification, replicaSpecifications = replicaSpecifications)
  output <- .keyspaces$create_table_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$create_table <- keyspaces_create_table

#' The CreateType operation creates a new user-defined type in the
#' specified keyspace
#'
#' @description
#' The [`create_type`][keyspaces_create_type] operation creates a new user-defined type in the specified keyspace.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_create_type/](https://www.paws-r-sdk.com/docs/keyspaces_create_type/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace.
#' @param typeName &#91;required&#93; The name of the user-defined type.
#' 
#' UDT names must contain 48 characters or less, must begin with an
#' alphabetic character, and can only contain alpha-numeric characters and
#' underscores. Amazon Keyspaces converts upper case characters
#' automatically into lower case characters.
#' 
#' Alternatively, you can declare a UDT name in double quotes. When
#' declaring a UDT name inside double quotes, Amazon Keyspaces preserves
#' upper casing and allows special characters.
#' 
#' You can also use double quotes as part of the name when you create the
#' UDT, but you must escape each double quote character with an additional
#' double quote character.
#' @param fieldDefinitions &#91;required&#93; The field definitions, consisting of names and types, that define this
#' type.
#'
#' @keywords internal
#'
#' @rdname keyspaces_create_type
keyspaces_create_type <- function(keyspaceName, typeName, fieldDefinitions) {
  op <- new_operation(
    name = "CreateType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$create_type_input(keyspaceName = keyspaceName, typeName = typeName, fieldDefinitions = fieldDefinitions)
  output <- .keyspaces$create_type_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$create_type <- keyspaces_create_type

#' The DeleteKeyspace operation deletes a keyspace and all of its tables
#'
#' @description
#' The [`delete_keyspace`][keyspaces_delete_keyspace] operation deletes a keyspace and all of its tables.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_delete_keyspace/](https://www.paws-r-sdk.com/docs/keyspaces_delete_keyspace/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace to be deleted.
#'
#' @keywords internal
#'
#' @rdname keyspaces_delete_keyspace
keyspaces_delete_keyspace <- function(keyspaceName) {
  op <- new_operation(
    name = "DeleteKeyspace",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$delete_keyspace_input(keyspaceName = keyspaceName)
  output <- .keyspaces$delete_keyspace_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$delete_keyspace <- keyspaces_delete_keyspace

#' The DeleteTable operation deletes a table and all of its data
#'
#' @description
#' The [`delete_table`][keyspaces_delete_table] operation deletes a table and all of its data. After a [`delete_table`][keyspaces_delete_table] request is received, the specified table is in the `DELETING` state until Amazon Keyspaces completes the deletion. If the table is in the `ACTIVE` state, you can delete it. If a table is either in the `CREATING` or `UPDATING` states, then Amazon Keyspaces returns a `ResourceInUseException`. If the specified table does not exist, Amazon Keyspaces returns a `ResourceNotFoundException`. If the table is already in the `DELETING` state, no error is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_delete_table/](https://www.paws-r-sdk.com/docs/keyspaces_delete_table/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace of the to be deleted table.
#' @param tableName &#91;required&#93; The name of the table to be deleted.
#'
#' @keywords internal
#'
#' @rdname keyspaces_delete_table
keyspaces_delete_table <- function(keyspaceName, tableName) {
  op <- new_operation(
    name = "DeleteTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$delete_table_input(keyspaceName = keyspaceName, tableName = tableName)
  output <- .keyspaces$delete_table_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$delete_table <- keyspaces_delete_table

#' The DeleteType operation deletes a user-defined type (UDT)
#'
#' @description
#' The [`delete_type`][keyspaces_delete_type] operation deletes a user-defined type (UDT). You can only delete a type that is not used in a table or another UDT.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_delete_type/](https://www.paws-r-sdk.com/docs/keyspaces_delete_type/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace of the to be deleted type.
#' @param typeName &#91;required&#93; The name of the type to be deleted.
#'
#' @keywords internal
#'
#' @rdname keyspaces_delete_type
keyspaces_delete_type <- function(keyspaceName, typeName) {
  op <- new_operation(
    name = "DeleteType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$delete_type_input(keyspaceName = keyspaceName, typeName = typeName)
  output <- .keyspaces$delete_type_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$delete_type <- keyspaces_delete_type

#' Returns the name of the specified keyspace, the Amazon Resource Name
#' (ARN), the replication strategy, the Amazon Web Services Regions of a
#' multi-Region keyspace, and the status of newly added Regions after an
#' UpdateKeyspace operation
#'
#' @description
#' Returns the name of the specified keyspace, the Amazon Resource Name (ARN), the replication strategy, the Amazon Web Services Regions of a multi-Region keyspace, and the status of newly added Regions after an [`update_keyspace`][keyspaces_update_keyspace] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_get_keyspace/](https://www.paws-r-sdk.com/docs/keyspaces_get_keyspace/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace.
#'
#' @keywords internal
#'
#' @rdname keyspaces_get_keyspace
keyspaces_get_keyspace <- function(keyspaceName) {
  op <- new_operation(
    name = "GetKeyspace",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$get_keyspace_input(keyspaceName = keyspaceName)
  output <- .keyspaces$get_keyspace_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$get_keyspace <- keyspaces_get_keyspace

#' Returns information about the table, including the table's name and
#' current status, the keyspace name, configuration settings, and metadata
#'
#' @description
#' Returns information about the table, including the table's name and current status, the keyspace name, configuration settings, and metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_get_table/](https://www.paws-r-sdk.com/docs/keyspaces_get_table/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace that the table is stored in.
#' @param tableName &#91;required&#93; The name of the table.
#'
#' @keywords internal
#'
#' @rdname keyspaces_get_table
keyspaces_get_table <- function(keyspaceName, tableName) {
  op <- new_operation(
    name = "GetTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$get_table_input(keyspaceName = keyspaceName, tableName = tableName)
  output <- .keyspaces$get_table_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$get_table <- keyspaces_get_table

#' Returns auto scaling related settings of the specified table in JSON
#' format
#'
#' @description
#' Returns auto scaling related settings of the specified table in JSON format. If the table is a multi-Region table, the Amazon Web Services Region specific auto scaling settings of the table are included.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_get_table_auto_scaling_settings/](https://www.paws-r-sdk.com/docs/keyspaces_get_table_auto_scaling_settings/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace.
#' @param tableName &#91;required&#93; The name of the table.
#'
#' @keywords internal
#'
#' @rdname keyspaces_get_table_auto_scaling_settings
keyspaces_get_table_auto_scaling_settings <- function(keyspaceName, tableName) {
  op <- new_operation(
    name = "GetTableAutoScalingSettings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$get_table_auto_scaling_settings_input(keyspaceName = keyspaceName, tableName = tableName)
  output <- .keyspaces$get_table_auto_scaling_settings_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$get_table_auto_scaling_settings <- keyspaces_get_table_auto_scaling_settings

#' The GetType operation returns information about the type, for example
#' the field definitions, the timestamp when the type was last modified,
#' the level of nesting, the status, and details about if the type is used
#' in other types and tables
#'
#' @description
#' The [`get_type`][keyspaces_get_type] operation returns information about the type, for example the field definitions, the timestamp when the type was last modified, the level of nesting, the status, and details about if the type is used in other types and tables.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_get_type/](https://www.paws-r-sdk.com/docs/keyspaces_get_type/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace that contains this type.
#' @param typeName &#91;required&#93; The formatted name of the type. For example, if the name of the type was
#' created without double quotes, Amazon Keyspaces saved the name in
#' lower-case characters. If the name was created in double quotes, you
#' must use double quotes to specify the type name.
#'
#' @keywords internal
#'
#' @rdname keyspaces_get_type
keyspaces_get_type <- function(keyspaceName, typeName) {
  op <- new_operation(
    name = "GetType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$get_type_input(keyspaceName = keyspaceName, typeName = typeName)
  output <- .keyspaces$get_type_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$get_type <- keyspaces_get_type

#' The ListKeyspaces operation returns a list of keyspaces
#'
#' @description
#' The [`list_keyspaces`][keyspaces_list_keyspaces] operation returns a list of keyspaces.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_list_keyspaces/](https://www.paws-r-sdk.com/docs/keyspaces_list_keyspaces/) for full documentation.
#'
#' @param nextToken The pagination token. To resume pagination, provide the `NextToken`
#' value as argument of a subsequent API invocation.
#' @param maxResults The total number of keyspaces to return in the output. If the total
#' number of keyspaces available is more than the value specified, a
#' `NextToken` is provided in the output. To resume pagination, provide the
#' `NextToken` value as an argument of a subsequent API invocation.
#'
#' @keywords internal
#'
#' @rdname keyspaces_list_keyspaces
keyspaces_list_keyspaces <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListKeyspaces",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "keyspaces"),
    stream_api = FALSE
  )
  input <- .keyspaces$list_keyspaces_input(nextToken = nextToken, maxResults = maxResults)
  output <- .keyspaces$list_keyspaces_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$list_keyspaces <- keyspaces_list_keyspaces

#' The ListTables operation returns a list of tables for a specified
#' keyspace
#'
#' @description
#' The [`list_tables`][keyspaces_list_tables] operation returns a list of tables for a specified keyspace.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_list_tables/](https://www.paws-r-sdk.com/docs/keyspaces_list_tables/) for full documentation.
#'
#' @param nextToken The pagination token. To resume pagination, provide the `NextToken`
#' value as an argument of a subsequent API invocation.
#' @param maxResults The total number of tables to return in the output. If the total number
#' of tables available is more than the value specified, a `NextToken` is
#' provided in the output. To resume pagination, provide the `NextToken`
#' value as an argument of a subsequent API invocation.
#' @param keyspaceName &#91;required&#93; The name of the keyspace.
#'
#' @keywords internal
#'
#' @rdname keyspaces_list_tables
keyspaces_list_tables <- function(nextToken = NULL, maxResults = NULL, keyspaceName) {
  op <- new_operation(
    name = "ListTables",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "tables"),
    stream_api = FALSE
  )
  input <- .keyspaces$list_tables_input(nextToken = nextToken, maxResults = maxResults, keyspaceName = keyspaceName)
  output <- .keyspaces$list_tables_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$list_tables <- keyspaces_list_tables

#' Returns a list of all tags associated with the specified Amazon
#' Keyspaces resource
#'
#' @description
#' Returns a list of all tags associated with the specified Amazon Keyspaces resource.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/keyspaces_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.
#' @param nextToken The pagination token. To resume pagination, provide the `NextToken`
#' value as argument of a subsequent API invocation.
#' @param maxResults The total number of tags to return in the output. If the total number of
#' tags available is more than the value specified, a `NextToken` is
#' provided in the output. To resume pagination, provide the `NextToken`
#' value as an argument of a subsequent API invocation.
#'
#' @keywords internal
#'
#' @rdname keyspaces_list_tags_for_resource
keyspaces_list_tags_for_resource <- function(resourceArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "tags"),
    stream_api = FALSE
  )
  input <- .keyspaces$list_tags_for_resource_input(resourceArn = resourceArn, nextToken = nextToken, maxResults = maxResults)
  output <- .keyspaces$list_tags_for_resource_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$list_tags_for_resource <- keyspaces_list_tags_for_resource

#' The ListTypes operation returns a list of types for a specified keyspace
#'
#' @description
#' The [`list_types`][keyspaces_list_types] operation returns a list of types for a specified keyspace.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_list_types/](https://www.paws-r-sdk.com/docs/keyspaces_list_types/) for full documentation.
#'
#' @param nextToken The pagination token. To resume pagination, provide the `NextToken`
#' value as an argument of a subsequent API invocation.
#' @param maxResults The total number of types to return in the output. If the total number
#' of types available is more than the value specified, a `NextToken` is
#' provided in the output. To resume pagination, provide the `NextToken`
#' value as an argument of a subsequent API invocation.
#' @param keyspaceName &#91;required&#93; The name of the keyspace that contains the listed types.
#'
#' @keywords internal
#'
#' @rdname keyspaces_list_types
keyspaces_list_types <- function(nextToken = NULL, maxResults = NULL, keyspaceName) {
  op <- new_operation(
    name = "ListTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "types"),
    stream_api = FALSE
  )
  input <- .keyspaces$list_types_input(nextToken = nextToken, maxResults = maxResults, keyspaceName = keyspaceName)
  output <- .keyspaces$list_types_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$list_types <- keyspaces_list_types

#' Restores the table to the specified point in time within the
#' earliest_restorable_timestamp and the current time
#'
#' @description
#' Restores the table to the specified point in time within the `earliest_restorable_timestamp` and the current time. For more information about restore points, see [Time window for PITR continuous backups](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_window) in the *Amazon Keyspaces Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_restore_table/](https://www.paws-r-sdk.com/docs/keyspaces_restore_table/) for full documentation.
#'
#' @param sourceKeyspaceName &#91;required&#93; The keyspace name of the source table.
#' @param sourceTableName &#91;required&#93; The name of the source table.
#' @param targetKeyspaceName &#91;required&#93; The name of the target keyspace.
#' @param targetTableName &#91;required&#93; The name of the target table.
#' @param restoreTimestamp The restore timestamp in ISO 8601 format.
#' @param capacitySpecificationOverride Specifies the read/write throughput capacity mode for the target table.
#' The options are:
#' 
#' -   `throughputMode:PAY_PER_REQUEST`
#' 
#' -   `throughputMode:PROVISIONED` - Provisioned capacity mode requires
#'     `readCapacityUnits` and `writeCapacityUnits` as input.
#' 
#' The default is `throughput_mode:PAY_PER_REQUEST`.
#' 
#' For more information, see [Read/write capacity
#' modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param encryptionSpecificationOverride Specifies the encryption settings for the target table. You can choose
#' one of the following KMS key (KMS key):
#' 
#' -   `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
#' 
#' -   `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account
#'     and is created, owned, and managed by you. This option requires the
#'     `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN)
#'     format as input.
#' 
#' The default is `type:AWS_OWNED_KMS_KEY`.
#' 
#' For more information, see [Encryption at
#' rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param pointInTimeRecoveryOverride Specifies the `pointInTimeRecovery` settings for the target table. The
#' options are:
#' 
#' -   `status=ENABLED`
#' 
#' -   `status=DISABLED`
#' 
#' If it's not specified, the default is `status=DISABLED`.
#' 
#' For more information, see [Point-in-time
#' recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param tagsOverride A list of key-value pair tags to be attached to the restored table.
#' 
#' For more information, see [Adding tags and labels to Amazon Keyspaces
#' resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param autoScalingSpecification The optional auto scaling settings for the restored table in provisioned
#' capacity mode. Specifies if the service can manage throughput capacity
#' of a provisioned table automatically on your behalf. Amazon Keyspaces
#' auto scaling helps you provision throughput capacity for variable
#' workloads efficiently by increasing and decreasing your table's read and
#' write capacity automatically in response to application traffic.
#' 
#' For more information, see [Managing throughput capacity automatically
#' with Amazon Keyspaces auto
#' scaling](https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param replicaSpecifications The optional Region specific settings of a multi-Regional table.
#'
#' @keywords internal
#'
#' @rdname keyspaces_restore_table
keyspaces_restore_table <- function(sourceKeyspaceName, sourceTableName, targetKeyspaceName, targetTableName, restoreTimestamp = NULL, capacitySpecificationOverride = NULL, encryptionSpecificationOverride = NULL, pointInTimeRecoveryOverride = NULL, tagsOverride = NULL, autoScalingSpecification = NULL, replicaSpecifications = NULL) {
  op <- new_operation(
    name = "RestoreTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$restore_table_input(sourceKeyspaceName = sourceKeyspaceName, sourceTableName = sourceTableName, targetKeyspaceName = targetKeyspaceName, targetTableName = targetTableName, restoreTimestamp = restoreTimestamp, capacitySpecificationOverride = capacitySpecificationOverride, encryptionSpecificationOverride = encryptionSpecificationOverride, pointInTimeRecoveryOverride = pointInTimeRecoveryOverride, tagsOverride = tagsOverride, autoScalingSpecification = autoScalingSpecification, replicaSpecifications = replicaSpecifications)
  output <- .keyspaces$restore_table_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$restore_table <- keyspaces_restore_table

#' Associates a set of tags with a Amazon Keyspaces resource
#'
#' @description
#' Associates a set of tags with a Amazon Keyspaces resource. You can then activate these user-defined tags so that they appear on the Cost Management Console for cost allocation tracking. For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_tag_resource/](https://www.paws-r-sdk.com/docs/keyspaces_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which
#' to add tags.
#' @param tags &#91;required&#93; The tags to be assigned to the Amazon Keyspaces resource.
#'
#' @keywords internal
#'
#' @rdname keyspaces_tag_resource
keyspaces_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .keyspaces$tag_resource_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$tag_resource <- keyspaces_tag_resource

#' Removes the association of tags from a Amazon Keyspaces resource
#'
#' @description
#' Removes the association of tags from a Amazon Keyspaces resource.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_untag_resource/](https://www.paws-r-sdk.com/docs/keyspaces_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Keyspaces resource that the tags will be removed from. This
#' value is an Amazon Resource Name (ARN).
#' @param tags &#91;required&#93; A list of existing tags to be removed from the Amazon Keyspaces
#' resource.
#'
#' @keywords internal
#'
#' @rdname keyspaces_untag_resource
keyspaces_untag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$untag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .keyspaces$untag_resource_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$untag_resource <- keyspaces_untag_resource

#' Adds a new Amazon Web Services Region to the keyspace
#'
#' @description
#' Adds a new Amazon Web Services Region to the keyspace. You can add a new Region to a keyspace that is either a single or a multi-Region keyspace. Amazon Keyspaces is going to replicate all tables in the keyspace to the new Region. To successfully replicate all tables to the new Region, they must use client-side timestamps for conflict resolution. To enable client-side timestamps, specify `clientSideTimestamps.status = enabled` when invoking the API. For more information about client-side timestamps, see [Client-side timestamps in Amazon Keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/client-side-timestamps.html) in the *Amazon Keyspaces Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_update_keyspace/](https://www.paws-r-sdk.com/docs/keyspaces_update_keyspace/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace.
#' @param replicationSpecification &#91;required&#93; 
#' @param clientSideTimestamps 
#'
#' @keywords internal
#'
#' @rdname keyspaces_update_keyspace
keyspaces_update_keyspace <- function(keyspaceName, replicationSpecification, clientSideTimestamps = NULL) {
  op <- new_operation(
    name = "UpdateKeyspace",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$update_keyspace_input(keyspaceName = keyspaceName, replicationSpecification = replicationSpecification, clientSideTimestamps = clientSideTimestamps)
  output <- .keyspaces$update_keyspace_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$update_keyspace <- keyspaces_update_keyspace

#' Adds new columns to the table or updates one of the table's settings,
#' for example capacity mode, auto scaling, encryption, point-in-time
#' recovery, or ttl settings
#'
#' @description
#' Adds new columns to the table or updates one of the table's settings, for example capacity mode, auto scaling, encryption, point-in-time recovery, or ttl settings. Note that you can only update one specific table setting per update operation.
#'
#' See [https://www.paws-r-sdk.com/docs/keyspaces_update_table/](https://www.paws-r-sdk.com/docs/keyspaces_update_table/) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace the specified table is stored in.
#' @param tableName &#91;required&#93; The name of the table.
#' @param addColumns For each column to be added to the specified table:
#' 
#' -   `name` - The name of the column.
#' 
#' -   `type` - An Amazon Keyspaces data type. For more information, see
#'     [Data
#'     types](https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types)
#'     in the *Amazon Keyspaces Developer Guide*.
#' @param capacitySpecification Modifies the read/write throughput capacity mode for the table. The
#' options are:
#' 
#' -   `throughputMode:PAY_PER_REQUEST` and
#' 
#' -   `throughputMode:PROVISIONED` - Provisioned capacity mode requires
#'     `readCapacityUnits` and `writeCapacityUnits` as input.
#' 
#' The default is `throughput_mode:PAY_PER_REQUEST`.
#' 
#' For more information, see [Read/write capacity
#' modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param encryptionSpecification Modifies the encryption settings of the table. You can choose one of the
#' following KMS key (KMS key):
#' 
#' -   `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
#' 
#' -   `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account
#'     and is created, owned, and managed by you. This option requires the
#'     `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN)
#'     format as input.
#' 
#' The default is `AWS_OWNED_KMS_KEY`.
#' 
#' For more information, see [Encryption at
#' rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param pointInTimeRecovery Modifies the `pointInTimeRecovery` settings of the table. The options
#' are:
#' 
#' -   `status=ENABLED`
#' 
#' -   `status=DISABLED`
#' 
#' If it's not specified, the default is `status=DISABLED`.
#' 
#' For more information, see [Point-in-time
#' recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param ttl Modifies Time to Live custom settings for the table. The options are:
#' 
#' -   `status:enabled`
#' 
#' -   `status:disabled`
#' 
#' The default is `status:disabled`. After `ttl` is enabled, you can't
#' disable it for the table.
#' 
#' For more information, see [Expiring data by using Amazon Keyspaces Time
#' to Live
#' (TTL)](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param defaultTimeToLive The default Time to Live setting in seconds for the table.
#' 
#' For more information, see [Setting the default TTL value for a
#' table](https://docs.aws.amazon.com/keyspaces/latest/devguide/#ttl-howitworks_default_ttl)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param clientSideTimestamps Enables client-side timestamps for the table. By default, the setting is
#' disabled. You can enable client-side timestamps with the following
#' option:
#' 
#' -   `status: "enabled"`
#' 
#' Once client-side timestamps are enabled for a table, this setting cannot
#' be disabled.
#' @param autoScalingSpecification The optional auto scaling settings to update for a table in provisioned
#' capacity mode. Specifies if the service can manage throughput capacity
#' of a provisioned table automatically on your behalf. Amazon Keyspaces
#' auto scaling helps you provision throughput capacity for variable
#' workloads efficiently by increasing and decreasing your table's read and
#' write capacity automatically in response to application traffic.
#' 
#' If auto scaling is already enabled for the table, you can use
#' [`update_table`][keyspaces_update_table] to update the minimum and
#' maximum values or the auto scaling policy settings independently.
#' 
#' For more information, see [Managing throughput capacity automatically
#' with Amazon Keyspaces auto
#' scaling](https://docs.aws.amazon.com/keyspaces/latest/devguide/autoscaling.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param replicaSpecifications The Region specific settings of a multi-Regional table.
#'
#' @keywords internal
#'
#' @rdname keyspaces_update_table
keyspaces_update_table <- function(keyspaceName, tableName, addColumns = NULL, capacitySpecification = NULL, encryptionSpecification = NULL, pointInTimeRecovery = NULL, ttl = NULL, defaultTimeToLive = NULL, clientSideTimestamps = NULL, autoScalingSpecification = NULL, replicaSpecifications = NULL) {
  op <- new_operation(
    name = "UpdateTable",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .keyspaces$update_table_input(keyspaceName = keyspaceName, tableName = tableName, addColumns = addColumns, capacitySpecification = capacitySpecification, encryptionSpecification = encryptionSpecification, pointInTimeRecovery = pointInTimeRecovery, ttl = ttl, defaultTimeToLive = defaultTimeToLive, clientSideTimestamps = clientSideTimestamps, autoScalingSpecification = autoScalingSpecification, replicaSpecifications = replicaSpecifications)
  output <- .keyspaces$update_table_output()
  config <- get_config()
  svc <- .keyspaces$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$update_table <- keyspaces_update_table
