% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_cost_forecast}
\alias{costexplorer_get_cost_forecast}
\title{Retrieves a forecast for how much Amazon Web Services predicts that you
will spend over the forecast time period that you select, based on your
past costs}
\usage{
costexplorer_get_cost_forecast(
  TimePeriod,
  Metric,
  Granularity,
  Filter = NULL,
  BillingViewArn = NULL,
  PredictionIntervalLevel = NULL
)
}
\arguments{
\item{TimePeriod}{[required] The period of time that you want the forecast to cover. The start date
must be equal to or no later than the current date to avoid a validation
error.}

\item{Metric}{[required] Which metric Cost Explorer uses to create your forecast. For more
information about blended and unblended rates, see Why does the
"blended" annotation appear on some line items in my bill?.

Valid values for a \code{\link[=costexplorer_get_cost_forecast]{get_cost_forecast}}
call are the following:
\itemize{
\item AMORTIZED_COST
\item BLENDED_COST
\item NET_AMORTIZED_COST
\item NET_UNBLENDED_COST
\item UNBLENDED_COST
}}

\item{Granularity}{[required] How granular you want the forecast to be. You can get 3 months of
\code{DAILY} forecasts or 12 months of \code{MONTHLY} forecasts.

The \code{\link[=costexplorer_get_cost_forecast]{get_cost_forecast}} operation
supports only \code{DAILY} and \code{MONTHLY} granularities.}

\item{Filter}{The filters that you want to use to filter your forecast. The
\code{\link[=costexplorer_get_cost_forecast]{get_cost_forecast}} API supports
filtering by the following dimensions:
\itemize{
\item \code{AZ}
\item \code{INSTANCE_TYPE}
\item \code{LINKED_ACCOUNT}
\item \code{LINKED_ACCOUNT_NAME}
\item \code{OPERATION}
\item \code{PURCHASE_TYPE}
\item \code{REGION}
\item \code{SERVICE}
\item \code{USAGE_TYPE}
\item \code{USAGE_TYPE_GROUP}
\item \code{RECORD_TYPE}
\item \code{OPERATING_SYSTEM}
\item \code{TENANCY}
\item \code{SCOPE}
\item \code{PLATFORM}
\item \code{SUBSCRIPTION_ID}
\item \code{LEGAL_ENTITY_NAME}
\item \code{DEPLOYMENT_OPTION}
\item \code{DATABASE_ENGINE}
\item \code{INSTANCE_TYPE_FAMILY}
\item \code{BILLING_ENTITY}
\item \code{RESERVATION_ID}
\item \code{SAVINGS_PLAN_ARN}
}}

\item{BillingViewArn}{The Amazon Resource Name (ARN) that uniquely identifies a specific
billing view. The ARN is used to specify which particular billing view
you want to interact with or retrieve information from when making API
calls related to Amazon Web Services Billing and Cost Management
features. The BillingViewArn can be retrieved by calling the
ListBillingViews API.}

\item{PredictionIntervalLevel}{Cost Explorer always returns the mean forecast as a single point. You
can request a prediction interval around the mean by specifying a
confidence level. The higher the confidence level, the more confident
Cost Explorer is about the actual value falling in the prediction
interval. Higher confidence levels result in wider prediction intervals.}
}
\description{
Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period that you select, based on your past costs.

See \url{https://www.paws-r-sdk.com/docs/costexplorer_get_cost_forecast/} for full documentation.
}
\keyword{internal}
