% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_search}
\alias{datazone_search}
\title{Searches for assets in Amazon DataZone}
\usage{
datazone_search(
  additionalAttributes = NULL,
  domainIdentifier,
  filters = NULL,
  maxResults = NULL,
  nextToken = NULL,
  owningProjectIdentifier = NULL,
  searchIn = NULL,
  searchScope,
  searchText = NULL,
  sort = NULL
)
}
\arguments{
\item{additionalAttributes}{Specifies additional attributes for the \code{\link[=datazone_search]{search}}
action.}

\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain.}

\item{filters}{Specifies the search filters.}

\item{maxResults}{The maximum number of results to return in a single call to
\code{\link[=datazone_search]{search}}. When the number of results to be listed is
greater than the value of \code{MaxResults}, the response contains a
\code{NextToken} value that you can use in a subsequent call to
\code{\link[=datazone_search]{search}} to list the next set of results.}

\item{nextToken}{When the number of results is greater than the default value for the
\code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of results, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to \code{\link[=datazone_search]{search}} to
list the next set of results.}

\item{owningProjectIdentifier}{The identifier of the owning project specified for the search.}

\item{searchIn}{The details of the search.}

\item{searchScope}{[required] The scope of the search.}

\item{searchText}{Specifies the text for which to search.}

\item{sort}{Specifies the way in which the search results are to be sorted.}
}
\description{
Searches for assets in Amazon DataZone.

See \url{https://www.paws-r-sdk.com/docs/datazone_search/} for full documentation.
}
\keyword{internal}
