% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pastaPlot.R
\name{pastaPlot}
\alias{pastaPlot}
\title{Spaghetti-plot fixed and random effects of linear mixed models}
\usage{
pastaPlot(
  model = NULL,
  predictor = NULL,
  nested.in = NULL,
  group = NULL,
  legend.title = "Legend",
  group.labels = NULL,
  xlab = NULL,
  ylab = NULL,
  font.family = NULL,
  colors = NULL,
  ci.lvl = 0.95,
  ci.int = FALSE,
  ci.linetype = 0,
  lwd.fix = 1,
  lwd.ran = 0.5,
  xlab.inc = 0,
  xlab.int = NULL,
  ylim = NULL,
  opacity.ci = 0.25,
  opacity.ran = 0.3,
  colors.ci = NULL
)
}
\arguments{
\item{model}{lme4 or glmmTMB model object}

\item{predictor}{(Character) Name of predictor (e.g., "time" or "math_score"), as it is present in the model}

\item{nested.in}{(Character) Name of the variable your time points or subjects are nested in (e.g.,"school" or "id")}

\item{group}{(Optional, character) The name of your grouping variable (e.g., "condition" or "gender")}

\item{legend.title}{(Optional, character) Name of legend in plot (e.g., "Condition", or "Gender")}

\item{group.labels}{(Optional, vector of characters) Names of group labels to be displayed in the plot (e.g., c("Control", "Intervention"))}

\item{xlab}{(Optional, character) Label of x-axis (predictor) (e.g., "Time (days)")}

\item{ylab}{(Optional, character) Label of y-axis (dependant variable) (e.g., "GAF")}

\item{font.family}{(Optional, character) Name of the font family (e.g. "serif")}

\item{colors}{(Optional, vector of characters) Set color of slopes. Length of vector should correspond to number of values in group variable (e.g., c("#5e9aff", "blue")). If no group variable is specified, pass a single color.}

\item{ci.lvl}{(Optional, numeric) Set confidence interval (default: 0.95)}

\item{ci.int}{(Optional, logical) Enable confidence (prediction) intervals, disabled by default}

\item{ci.linetype}{(Optional, numeric) Set linetype of confidence bands outline (default: 0)}

\item{lwd.fix}{(Optional, numeric) Line width of fixed effects (default: 1)}

\item{lwd.ran}{(Optional, numeric) Line width of random effects (default: 0.5)}

\item{xlab.inc}{(Optional, numeric) Increment the displayed values of your predictor (e.g., xlab_int = 1 changes range of x from 0-29 to 1-30), set to 0 by default}

\item{xlab.int}{(Optional, numeric) Interval between displayed predictor values on x-axis (e.g., "1"), disabled by default}

\item{ylim}{(Optional, numeric vector) Limited range of values on y-axis (e.g. c(1,5.5))}

\item{opacity.ci}{(Optional, numeric) Set opacity of confidence bands in the range of 0 to 1 (default = 0.1)}

\item{opacity.ran}{(Optional, numeric) Set opacity of random slopes in the range of 0 to 1 (default = 0.4)}

\item{colors.ci}{(Optional, vector of characters) Set color of confidence bands. Length of vector should correspond to number of values in group variable (e.g., c("#5e9aff", "blue")). If no group variable is specified, pass a single color.}
}
\value{
Returns a ggplot2 plot object to further be modified
}
\description{
\code{pastaPlot()} plots slopes for both fixed and random effects of linear mixed models from 'lme4' or 'glmmTMB' packages as a single spaghetti plot, optionally between conditions including confidence bands for fixed effects.
}
\examples{
lme4_model <- lme4::lmer(CO2 ~ 1 + time*condition + (1 + time | id),
data=ecovia_data, REML = FALSE, control = lme4::lmerControl(optimizer = "bobyqa"))
pastaPlot(lme4_model, "time", "id", group = "condition", legend.title = "Condition",
group.labels = c("Control", "Intervention"), ci.int = TRUE, xlab = "Time (days)",
ylab = "CO2")

glmmTMB_model <- glmmTMB::glmmTMB(math_score_y3 ~ 1 + math_score_y1*gender +
(1 + math_score_y1 | school), data=jsp_data, REML = FALSE)
pastaPlot(glmmTMB_model, "math_score_y1", "school", group = "gender",
legend.title = "Gender", group.labels = c("Male", "Female"), ci.int = FALSE,
xlab = "Math score (year 1)", ylab = "Math score (year 3)")
}
