% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correl_panel.R
\name{panel_correl}
\alias{panel_correl}
\title{Panel linear combinations}
\usage{
panel_correl(data, cross.section = NULL, time.variable = NULL,
  corr.threshold = 0.7, autocorr.threshold = 0.5,
  cross.threshold = 0.7, select.cross.sections = NULL,
  select.time.periods = NULL)
}
\arguments{
\item{data}{The data to use, a data.frame or a data.table.}

\item{cross.section}{The name of the cross sectional variable.}

\item{time.variable}{The name of the time variable.}

\item{corr.threshold}{The correlation threshold for finding significant correlations in the base specification, disregarding time or cross sectional dependencies.}

\item{autocorr.threshold}{The correlation threshold for autocorrelation (splitting the pooled panel into cross sections).}

\item{cross.threshold}{The correlation threshold for finding significant correlations in the cross sections.}

\item{select.cross.sections}{An optional subset of cross sectional units.}

\item{select.time.periods}{An optional subset of time periods}
}
\description{
A function to find highly correlated variables in a panel of data, both by cross sections and by time dummies.
}
\examples{

   x_1 <- rnorm( 100 )
   x_2 <- rnorm( 100 ) + 0.5 * x_1
   cross_levels <- c( "AT", "DE")
   time <- seq(1:50)
   time <- rep(time, 2)
   geo_list <- list()
   for(i in 1:length(cross_levels))
   {  geo <- rep( cross_levels[i], 50 )
      geo_list[[i]] <- geo }
   geo <- unlist(geo_list)
   geo <- as.data.frame(geo)

   example_data <-  do.call ( cbind, list( time, x_1, x_2))
   example_data <- as.data.frame(example_data)
   example_data <- cbind( geo,
                         example_data)

                         names(example_data) <- c("geo", "time", "x_1",
                                                 "x_2")

   panel_correl( data = example_data,
                 cross.section = "geo",
                 time.variable = "time",
                 corr.threshold = 0.2,
                 autocorr.threshold = 0.5,
                 cross.threshold = 0.1)

}
