% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autopal.R
\name{autolegend}
\alias{autolegend}
\title{Add Auto-Generated Legend}
\usage{
autolegend(...)
}
\arguments{
\item{...}{Arguments passed directly to \code{legend} -- legend text and colours are taken
automatically from \code{options('autolegend')}. See examples for useful
parameters, including \code{pch} and \code{pt.cex}}
}
\value{
No return value (\code{NULL})
}
\description{
Add a legend for the last \code{autocol()} set generated
}
\details{
If no location (such as 'top', 'above', or an x,y coordinate) is given, then it
calls the \code{locator()} crosshairs so the position of the legend can be picked
interactively. All arguments are passed to \code{legend()}, see \code{?legend} for a full
list.

Positions 'above' and 'below' are allowed which shorthand for inset and
horizontal (see example).

Legend labels and fill are generated by either \code{autopal()} or \code{autocol()} and
stored in the global \code{options('autolegend')} where they can be manipulated
if needs be.

See more examples in ?autocol for a \code{plot()} and \code{autolegend()} work flow.
}
\examples{
# Simplest version: click-to-draw with locator()
plot(1:10, pch=16, col=autocol(1:10, 'Blues', legend_len=5))
# autolegend() # Try me! And click on plot to add legend

# Other neat versions -- note ?legend
autolegend('above', title='Above plot')
# Exactly equivalent to...
autolegend('bottom', inset=1, horiz=TRUE, bty='n')
autolegend(x=6, y=4, ncol=2, title='Draw at (6,4)')
autolegend('topleft', title='"topleft"', ncol=2, bty='n')

# Use pch (and optionally pt.cex) in legend -- these get recycled
autolegend('bottom', horiz=TRUE, pch=16, pt.cex=3, title='pch=16, pt.cex=3')
autolegend('right', pch=1:10, pt.cex=2, title='pch=1:10')

# Manipulate the legend text, for example with format(), this is a bit long-winded!
heatmap(as.matrix(eurodist), col=autopal('turbo', limits=range(eurodist)) )
current_legend = options('autolegend')[[1]]
options(autolegend = list(format(current_legend[[1]], big.mark=','), current_legend[[2]]))
autolegend('bottom', inset=1, horiz=TRUE, title='Misleading miles between cities')

# No helper exists yet for creating size or shape legends -- follow this idea...
with(airquality, plot(Temp, pch=16, cex=Solar.R/100, col=autocol(Ozone, set='Reds')))
cex_legend = pretty(airquality$Solar.R)
legend('bottom', pt.cex=cex_legend/100, legend=cex_legend, pch=1,
  horiz=TRUE, title='Solar.R', bty='n' )
autolegend('above', title='Ozone')

}
