% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvm.R
\name{covar}
\alias{covar}
\title{Calculate covariance matrix between individual landmark coordinates}
\usage{
covar(A)
}
\arguments{
\item{A}{An N x 3 x M array where N is the number of landmarks, 3 is the number of dimensions, and M is the number of specimens.}
}
\value{
3N x 3N covariance matrix
}
\description{
Calculate covariance matrix between individual landmark coordinates. 
  Skips any missing values in computation of covariance matrix.
}
\details{
This function does not guarantee that the returned matrix is  
 positive definite. If the covariance matrix is not positive definite 
 a warning is given and the matrix can be bent to create the closest
 positive definite matrix with \code{as.matrix(Matrix::nearPD(mat)$mat)}.
}
\examples{
A <- array(rnorm(4 * 2 * 3), dim = c(2, 3, 4)) 
A.cov <- covar(A)
}
