% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim}
\alias{sim}
\alias{is.sim}
\alias{print.sim}
\alias{head.sim}
\alias{tail.sim}
\alias{summary.sim}
\alias{plot.sim}
\alias{sim.counts}
\title{Details, generics, and methods for the \code{sim} class}
\usage{
is.sim(sim)

\method{print}{sim}(x, ...)

\method{head}{sim}(x, ...)

\method{tail}{sim}(x, ...)

\method{summary}{sim}(object, ...)

\method{plot}{sim}(x, ...)

sim.counts(sim, t)
}
\arguments{
\item{sim, x, object}{Object of class "sim"}

\item{...}{Further arguments inherited from generics.}

\item{t}{Time t (in Mya). Used for counting and/or plotting births, deaths
and species number.}
}
\description{
The \code{sim} class is a frequent return and input argument for functions in
paleobuddy. It contains the following four elements.

\describe{
\item{\code{TE}}{Numeric vector of extinction times, with \code{NA} as the time of
extinction for extant species.}

\item{\code{TS}}{Numeric vector of speciation times, with \code{tMax} as the time of
speciation for species that started the simulation.}

\item{\code{PAR}}{Numeric vector of parents. Species that started the simulation have
\code{NA}, while species that were generated during the simulation have their
parent's number. Species are numbered as they are born.}

\item{\code{EXTANT}}{Vector of logicals representing whether each species is
extant.}}

Here we declare useful generics and methods for \code{sim} objects.
}
\details{
\code{is.sim} A \code{sim} object must contain 4 members (usually 
vectors for extinction times, speciation times, species' parents and status), 
and all of these must have the correct length (i.e. same as all the others) and
types. We do not utilize the members' order inside \code{sim} for our tests, 
since they are accessed with the $ operator and therefore the order is 
irrelevant.

\code{print.sim} The printing of a sim object is formatted into a more
straightforward and informative sequence manner. We provide details only for 
the first few species, since otherwise this print could be overwhelming for 
simulations with 10+ species.

\code{head.sim} Selects only a number of species from the beginning
of a \code{sim} object.

\code{tail.sim} Selects only a number of species from the end of a
\code{sim} object.

\code{summary.sim} Quantitative details on the \code{sim} object. 
Prints the number of species, number of extant species, summary of durations
and speciation waiting times, in case there are more than one species.

\code{plot.sim} Plots births, deaths, and diversity through time for
the sim object.

\code{sim.counts} Calculates the births, deaths, and diversity for a 
sim at time t.
}
