% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_worldclim_historic.R
\name{get_worldclim_historic}
\alias{get_worldclim_historic}
\title{Descargar y procesar variables climáticas históricas de WorldClim v2.1}
\usage{
get_worldclim_historic(
  var = "bio",
  res = 10,
  aoi = NULL,
  retries = 3,
  timeout = 300,
  destination_dir = NULL
)
}
\arguments{
\item{var}{Character. Variable climática a descargar. Opciones:
\itemize{
  \item "bio" — Variables bioclimáticas.
  \item "tavg" — Temperatura media.
  \item "tmin" — Temperatura mínima.
  \item "tmax" — Temperatura máxima.
  \item "prec" — Precipitación.
  \item "srad" — Radiación solar.
  \item "wind" — Velocidad del viento.
  \item "vapr" — Presión de vapor.
}
Por defecto: `"bio"`.}

\item{res}{Numeric. Resolución espacial en minutos de arco.
Valores válidos: `0.5`, `2.5`, `5`, `10`.
Estos valores se mapean internamente a cadenas aceptadas por WorldClim:
\itemize{
  \item 0.5 → "30s"
  \item 2.5 → "2.5m"
  \item 5   → "5m"
  \item 10  → "10m"
}
Por defecto: `10`.}

\item{aoi}{sf o SpatRaster opcional. Área de interés para recortar los datos.}

\item{retries}{Integer. Número de intentos de descarga en caso de fallo.
Por defecto: `3`.}

\item{timeout}{Numeric. Tiempo máximo de descarga en segundos.
Por defecto: `300`.}

\item{destination_dir}{Character. Carpeta donde guardar los datos descargados.
Si NULL, se usa un directorio temporal.}
}
\value{
Un objeto `SpatRaster` con las variables climáticas históricas.
  Si se especifica `aoi`, los datos se recortan a esa área.
}
\description{
Descarga datos climáticos históricos de WorldClim v2.1 y los procesa
según los parámetros especificados. Soporta múltiples variables climáticas
y resoluciones espaciales. Opcionalmente recorta los datos a un área de interés (AOI).
}
\examples{
\donttest{
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"))
nc <- sf::st_transform(nc, crs = 4326)

climate_historic <- get_worldclim_historic(
  var = "tmin",
  res = 5,
  aoi = nc
)
}

}
\references{
Fick, S. E., & Hijmans, R. J. (2017). WorldClim 2: new 1-km spatial resolution climate surfaces for global land areas.
International Journal of Climatology, 37(12), 4302–4315. \doi{10.1002/joc.5086}
}
