% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_lcwm.R
\name{uniform_outlier_ombc}
\alias{uniform_outlier_ombc}
\title{Produce a single sample that passes the outlier checks.}
\usage{
uniform_outlier_ombc(
  outlier_type,
  mu,
  sigma,
  beta,
  error_sd,
  g,
  uniform_spans,
  prob_range
)
}
\arguments{
\item{outlier_type}{Character string governing whether the outliers are
outlying with respect to the explanatory variable only
(\code{"x_only"}), the response variable only (\code{"y_only"}), or
both (\code{"x_and_y"}). \code{"x_and_y"} is the default value.}

\item{mu}{List of component mean vectors.}

\item{sigma}{List of component covariance matrices.}

\item{beta}{List of component regression coefficient vectors.}

\item{error_sd}{Vector of component regression error standard deivations.}

\item{g}{Component index.}

\item{uniform_spans}{Covariate and response error spans.}

\item{prob_range}{Values for uniform sample rejection.}
}
\value{
\code{uniform_outlier_ombc} returns a simulated outlier as a vector containing its
covariate values, response value, and its component label \code{0}. This vector's
final element is the probability of sampling a more extreme Gaussian point
from this outlier's associated component.
}
\description{
This function calls \link{uniform_sample_lcwm} to sample a proposed outlier and
then calls \link{test_outlier_ombc} to check if it satisfies the required
criteria.
}
