% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrib_diff.R
\name{distrib_diff_lcwm}
\alias{distrib_diff_lcwm}
\title{Compute the dissimilarity for a linear cluster-weighted model and
identify the lowest density observation.}
\usage{
distrib_diff_lcwm(x, z, prop, mu, sigma, mod_list, y_sigma, dd_weight = 0.5)
}
\arguments{
\item{x}{Covariate data only.}

\item{z}{Component assignment probability matrix.}

\item{prop}{Vector of component proportions.}

\item{mu}{Matrix of component mean vectors.}

\item{sigma}{Array of component covariance matrices.}

\item{mod_list}{List of component regression models.}

\item{y_sigma}{Vector of component regression standard deviations.}

\item{dd_weight}{A value between \code{0} and \code{1} which controls the weighting of
the response and covariate dissimilarities when aggregating.}
}
\value{
\code{distrib_diff_lcwm_lcwm} returns a list with the following elements:
\describe{
\item{\code{distrib_diff}}{Aggregated dissimilarity across components.}
\item{\code{distrib_diff_vec}}{Vector containing dissimilarity value for each
component.}
\item{\code{choice_id}}{Index of observation with lowest mixture density.}
\item{\code{removal_dens}}{Value of the lowest mixture density.}
\item{\code{distrib_diff_mat}}{Two-column matrix containing response and
covariate dissimilarities across components.}
}
}
\description{
At each iteration of \link{ombc_lcwm}, \code{distrib_diff_lcwm} computes the
dissimilarity value of the current linear cluster-weighted model. It also
identifies the observation with the lowest mixture density.
}
