% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_handling.R
\name{check_git_repo}
\alias{check_git_repo}
\title{Check if a repository exists on GitHub}
\usage{
check_git_repo(
  repo_name,
  token = NULL,
  silent = TRUE,
  return_repo = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{repo_name}{the name of the repository, e.g. jhudsl/OTTR_Template}

\item{token}{A personal access token from GitHub. Only necessary if the
repository being checked is a private repository.}

\item{silent}{TRUE/FALSE of whether the warning from the git ls-remote
command should be echoed back if it does fail.}

\item{return_repo}{TRUE/FALSE of whether or not the output from git ls-remote
should be saved to a file (if the repo exists)}

\item{verbose}{TRUE/FALSE do you want more progress messages?}
}
\value{
A TRUE/FALSE whether or not the repository exists. Optionally the
output from git ls-remote if return_repo = TRUE.
}
\description{
Given a repository name, check with git ls-remote whether the repository exists and return a TRUE/FALSE
}
\examples{
\dontrun{

authorize("github")
check_git_repo("jhudsl/OTTR_Template")
}
}
