% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_project.R
\name{set_results}
\alias{set_results}
\title{Set results folder after project initialization}
\usage{
set_results(results, proj = org::project)
}
\arguments{
\item{results}{A character vector specifying one or more possible results folder paths.
The first existing path will be used.}

\item{proj}{The project environment. Default is \code{org::project}.}
}
\value{
Nothing. Modifies the \code{proj} environment to include:
\describe{
\item{$results}{The base results folder path}
\item{$results_today}{Path to today's results folder (format: YYYY-MM-DD)}
}
}
\description{
Sets the results folder in the project environment and creates a date-based subfolder.
The date-based folder is accessible via \code{proj$results_today} and empty date folders
are automatically cleaned up when new results are added.
}
