% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margins.R
\name{summary.margins.orf}
\alias{summary.margins.orf}
\title{Summary of the Ordered Forest Marginal Effects}
\usage{
\method{summary}{margins.orf}(object, latex = FALSE, ...)
}
\arguments{
\item{object}{estimated Ordered Forest Marginal Effect object of type \code{margins.orf}}

\item{latex}{logical, if TRUE latex coded summary will be generated (default is FALSE)}

\item{...}{further arguments (currently ignored)}
}
\description{
summary of estimated marginal effects of the Ordered Forest of class \code{margins.orf}
}
\details{
\code{summary.margins.orf} provides estimation results of the Ordered Forest
marginal effects. The summary contains the results for the marginal effects
for each covariate and each outcome class, optionally with inference as well.
Furthermore, summary output as a LaTeX table is supported in order to directly
extract the results for the documentation.
}
\examples{
## Ordered Forest
require(orf)

# load example data
data(odata)

# specify response and covariates
Y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

# estimate Ordered Forest
orf_fit <- orf(X, Y)
\donttest{
# estimate marginal effects of the orf
orf_margins <- margins(orf_fit)

# summary of marginal effects
summary(orf_margins)

# summary of marginal effects coded in LaTeX
summary(orf_margins, latex = TRUE)
}

}
\author{
Gabriel Okasa
}
