test_that("teachers example is right", {
  n <- teachers
  x <- log_linear_main_effect_design(n)
  result <- log_linear_fit(n, x)
  expect_true(abs(23.79 - result$g_squared) <= 0.005)

  x <- log_linear_equal_weight_agreement_design(n)
  result <- log_linear_fit(n, x)
  expect_true(abs(10.08 - result$g_squared) <= 0.005)
}
)


test_that("depression example is correct", {
  n <- depression

  x <- log_linear_main_effect_design(n)
  result <- log_linear_fit(n, x)
  expect_true(abs(39.03 - result$g_squared) <= 0.005)
  expect_equal(4, result$df)

  x <- log_linear_equal_weight_agreement_design(n)
  result <- log_linear_fit(n, x)
  expect_true(abs(9.22 - result$g_squared) <= 0.005)
  expect_equal(3, result$df)

  w <- c(1, 2, 3)
  x <- log_linear_equal_weight_agreement_design(n)
  x <- von_Eye_weight_by_response_category_design(n, x=x, w=w)
  result <- log_linear_fit(n, x)
  expect_true(abs(13.49 - result$g_squared) <= 0.005)
  expect_equal(3, result$df)
}
)


test_that("continuous covariate example works", {
  n <- depression
  x <- log_linear_equal_weight_agreement_design(n)
  covariate <- c(17, 27, 3, 16, 45, 14, 1, 3, 3)
  x_prime <- log_linear_append_column(x, covariate)
  result <- log_linear_fit(n, x_prime)
  expect_true(abs(1.85 - result$g_squared) < 0.005)
  expect_equal(2, result$df)

  beta <- result$beta
  se <- result$se
  M <- length(beta)
  # NOTE: in book these are switched.
  expect_true(abs(3.65 - beta[M - 1]) <= 0.02, info=paste(3.65, beta[M - 1]))
  expect_true(abs(1.13 - se[M - 1]) <= 0.01, info=paste(1.13, se[M - 1]))
  expect_true(abs(-0.16 - beta[M]) <= 0.005, info=paste(-0.16, beta[M]))
  expect_true(abs(0.074 - se[M]) <= 0.0005, info=paste(0.074), se[M])
}
)


test_that("tv_models_are_correct", {
  x <- log_linear_main_effect_design(tv)
  result <- log_linear_fit(tv, x)
  expect_true(abs(54.53 - result$g_squared) <= 0.005)
  expect_equal(25, result$df)

  x <- log_linear_equal_weight_agreement_design(tv)
  result2 <- log_linear_fit(tv, x)
  expect_true(abs(44.03 - result2$g_squared) <= 0.005)
  expect_equal(24, result2$df)

  linear_linear <- log_linear_create_linear_by_linear(tv, TRUE)
  x_prime <- log_linear_append_column(x, linear_linear, ncol(x))
  result3 <- log_linear_fit(tv, x_prime)
  expect_true(abs(28.72 - result3$g_squared) <= 0.005)
  expect_equal(23, result3$df)
  beta <- result3$beta
  se <- result3$se
  M <- length(beta)
  expect_true(abs(0.22 - beta[M - 1]) <= 0.005)
  expect_true(abs(0.06 - se[M - 1]) <= 0.005)
  expect_true(abs(0.34 - beta[M]) <= 0.005)
  expect_true(abs(0.25 - se[M]) <= 0.005)

  w <- c(3, 2, 1, 1, 2, 3)
  x2 <- von_Eye_weight_by_response_category_design(n=tv, x=x_prime, w=w)
  result4 <- log_linear_fit(tv, x2)
  expect_true(abs(28.19 - result4$g_squared) <= 0.005)
  expect_equal(23, result4$df)
  beta <- result4$beta
  se <- result4$se
  M <- length(beta)
  expect_true(abs(0.209 - beta[M - 1]) <= 0.0005, info=paste(0.209, beta[M - 1]))
  expect_true(abs(0.068 - se[M - 1]) <= 0.0005, info=paste(0.068, se[M - 1]))
  expect_true(abs(0.209 - beta[M]) <= 0.0005)
  expect_true(abs(0.138 - se[M]) <= 0.0005)
}
)


test_that("radiology models are correct", {
  x <- log_linear_main_effect_design(radiology)
  result <- log_linear_fit(radiology, x)
  expect_true(abs(117.96 - result$g_squared) <= 0.005)
  expect_equal(9, result$df)

  x <- log_linear_equal_weight_agreement_design(radiology)
  w <- c(4.0, 1.0, 1.0, 4.0)
  x <- von_Eye_weight_by_response_category_design(radiology, x, w)
  result2 <- log_linear_fit(radiology, x)
  expect_true(abs(15.14 - result2$g_squared) <= 0.005)
  expect_equal(8, result2$df)

  linear_linear <- log_linear_create_linear_by_linear(radiology)
  x_prime <- log_linear_append_column(x, linear_linear)
  result3 <- log_linear_fit(radiology, x_prime)
  expect_true(abs(3.86 - result3$g_squared) <= 0.005)
  expect_equal(result3$df, 7)
  beta <- result3$beta
  se <- result3$se
  M <- length(beta)
  expect_true(abs(0.45 - beta[M - 1]) <= 0.005, info=paste(0.45,  beta[M - 1]))
  expect_true(abs(0.21 - se[M - 1]) <= 0.005, info=paste(0.21, se[M - 1]))
  expect_true(abs(1.18 - beta[M]) <= 0.005, info=paste(1.18, beta[M]))
  expect_true(abs(0.44 - se[M]) <= 0.01, info=paste(0.44, se[M]))

  covariate <- c(1.4, 2.0, 2.2, 0.0, 2.1,
                 2.2, 2.0, 0.0, 0.0, 2.2,
                 2.5, 0.0, 0.0, 2.2, 2.3,
                 1.7)
  x_prime_prime <- log_linear_append_column(x_prime, covariate)
  result4 <- log_linear_fit(radiology, x_prime_prime)
  expect_true(abs(1.00 - result4$g_squared) <= 0.005)
  expect_equal(6, result4$df)
}
)


test_that("rater specific trends model is correct", {
  n <- paranoia
  x <- log_linear_main_effect_design(n)
  result <- log_linear_fit(paranoia, x)
  expect_true(abs(9.10 - result$g_squared) <= 0.005)
  expect_equal(4, result$df)

  x <- log_linear_equal_weight_agreement_design(n)
  x_additional <- c(0, 1, 1, -1, 0, 1, -1, -1, 0)
  x_prime <- log_linear_append_column(x, x_additional)
  result2 <- log_linear_fit(n, x_prime)
  expect_true(abs(3.45 - result2$g_square) <= 0.01,
              info=paste(3.45, result2$g_square))
  expect_equal(2, result2$df)
  beta <- result2$beta
  se <- result2$se
  M <- length(beta)
  expect_true(abs(0.37 - beta[M - 1]) <= 0.005)
  expect_true(abs(0.20 - se[M - 1]) <= 0.005)
  expect_true(abs(0.82 - beta[M]) <= 0.005)
  expect_true(abs(0.48 - se[M]) <= 0.01, info=paste(0.48, se[M]))
}
)


test_that("multiple sclerosis data are correct", {
  n <- new_orleans_data
  x <- log_linear_main_effect_design(n)
  result <- log_linear_fit(n, x)
  expect_true(abs(46.264 - result$g_squared) <= 0.001,
              info=paste(46.264, result$g_squared))
  expect_equal(9, result$df)

  x <- log_linear_equal_weight_agreement_design(n)
  w <- c(5, 1, 1, 5)
  x <- von_Eye_weight_by_response_category_design(n, x, w)
  result2 <- log_linear_fit(n, x)
  # NOTE: books gives this as 14.430
  expect_true(abs(15.429 - result2$g_squared) <= 0.005,
              info=paste(14.430, result2$g_squared))
  expect_equal(8, result2$df)
}
)


test_that("final depression example in chapter 2 is correct", {
  n <- depression
  x <- log_linear_main_effect_design(n)
  result <- log_linear_fit(n, x)
  expect_true(abs(39.03 - result$g_squared) <= 0.005)
  expect_equal(4, result$df)

  x <- log_linear_equal_weight_agreement_design(n)
  result2 <- log_linear_fit(n, x)
  expect_true(abs(9.22 - result2$g_squared) <= 0.005)
  expect_equal(3, result2$df)
}
)
