% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{orderly_validate_archive}
\alias{orderly_validate_archive}
\title{Validate unpacked packets.}
\usage{
orderly_validate_archive(
  expr = NULL,
  name = NULL,
  action = "inform",
  root = NULL
)
}
\arguments{
\item{expr}{The query expression. A \code{NULL} expression matches everything.}

\item{name}{Optionally, the name of the packet to scope the query on. This
will be intersected with \code{scope} arg and is a shorthand way of running
\code{scope = list(name = "name")}}

\item{action}{The action to take on finding an invalid packet. See
Details.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Invisibly, a character vector of repaired (or invalid)
packets.
}
\description{
Validate unpacked packets. Over time, expect this function to
become more fully featured, validating more.
}
\details{
The actions that we can take on finding an invalid packet are:
\itemize{
\item \code{inform} (the default): just print information about the problem
\item \code{orphan}: mark the packet as orphaned within the metadata, but
do not touch the files in your archive (by default the directory
\verb{archive/}) - this is a safe option and will leave you in a
consistent state without deleting anything.
\item \code{delete}: in addition to marking the packet as an orphan, also
delete the files from your archive.
}

Later, we will add a "repair" option to try and fix broken
packets.

The validation interacts with the option
\code{core.require_complete_tree}; if this option is \code{TRUE}, then a
packet is only valid if all its (recursive) dependencies are also
valid, so the action will apply to packets that have also had
their upstream dependencies invalidated.  This validation will
happen even if the query implied by \code{...} does not include these
packets if a complete tree is required.

The validation will also interact with \code{core.use_file_store} once
repair is supported, as this becomes trivial.
}
\examples{
# Start with an archive containing 4 simple packets
path <- orderly_example()
ids <- vapply(1:4, function(i) orderly_run("data", root = path), "")

# Suppose someone corrupts a packet by deleting a file:
fs::file_delete(file.path(path, "archive", "data", ids[[3]], "data.rds"))

# We can check all packets, and report on validity
orderly_validate_archive(root = path)

# Alternatively, we can take action and orphan the invalid packet:
orderly_validate_archive(action = "orphan", root = path)

# At which point the validation will not find this packet anymore
orderly_validate_archive(root = path)

# The orphaned packet will no longer be found in most operations:
orderly_search(root = path)
}
