% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_constant.R, R/is_increasing.R,
%   R/is_incremental.R, R/is_monotonic.R, R/is_sorted.R
\name{is_constant}
\alias{is_constant}
\alias{is_increasing}
\alias{is_strictly_increasing}
\alias{is_decreasing}
\alias{is_strictly_decreasing}
\alias{is_incremental}
\alias{is_uniform}
\alias{is_monotonic}
\alias{is_strictly_monotonic}
\alias{is_sorted}
\alias{is_strictly_sorted}
\alias{is_unsorted}
\alias{is_strictly_unsorted}
\title{ordering  Tests}
\usage{
is_constant(x, na.rm = TRUE)

is_increasing(x, na.rm = TRUE)

is_strictly_increasing(x, na.rm = na.omit)

is_decreasing(x, na.rm = na.omit)

is_strictly_decreasing(x, na.rm = na.omit)

is_incremental(x, step = 1, na.rm = TRUE)

is_uniform(x, step = NULL, na.rm = TRUE)

is_monotonic(x, na.rm = TRUE)

is_strictly_monotonic(x, na.rm = TRUE)

is_sorted(x, na.rm = TRUE)

is_strictly_sorted(x, na.rm = TRUE)

is_unsorted(...)

is_strictly_unsorted(...)
}
\arguments{
\item{x}{vector}

\item{na.rm}{function or NULL; action to perform on input to handle the
missing values}

\item{step}{integer; step size for \code{is_incremental}. (Default: 1)`}

\item{...}{used for passing default arguments}
}
\value{
logical or NA. (NB: NA is returned because it is a logical vector and this is
needed to put these results cleanly in tables.)

logical
}
\description{
Tests vectors for (strictly) increasing, decreasing, monotonic and
constant properties
}
\details{
Tests to various monotone properties of vectors.

\code{is_incremental} determines if x is incremental, i.e. monotonic and equally
spaced.

\code{is_uniform} is a wrapper around \code{is_incremental} with \code{step=1}

\code{is_[strictly_]monotonic} determine the sort properties of \code{x}.

This differes from \code{\link[base:is.unsorted]{base::is.unsorted()}} which should more properly be called
\code{is.increasing} since \code{base::is.unsorted(3:1) == TRUE}; \code{3:1} is obviously
sorted.

\code{\link[=is_sorted]{is_sorted()}} is a alias for \code{\link[=is_monotonic]{is_monotonic()}} and \code{\link[=is_strictly_sorted]{is_strictly_sorted()}} is
an alias for \code{\link[=is_strictly_monotonic]{is_strictly_monotonic()}}.
}
\note{
The behavior of this package is The functions \code{\link[base:is.unsorted]{base::is.unsorted()}} is perhaps misnamed and should properly be
names \code{is_not_increasing} since \code{base::is.unsorted(3:1) == TRUE} after all
vector 3,2,1 is sorted but not increasing.
}
\examples{
  
  is_constant( rep(3,5) )

  is_increasing( 1:5 )                   # TRUE
  is_increasing( c(1,2,1,3) )            # FALSE
  
  is_increasing( c(1,NA,2,3) )           # NA 
  is_increasing( c(1,NA,2,3), na.omit )  # TRUE

  is_monotonic( 1:5 )                    # TRUE
  is_monotonic( -5:5 )                   # TRUE
  is_monotonic( 5:-5 )                   # TRUE
  is_monotonic( c(1,5,3))                # FALSE
  

  is_incremental(1:5 )
  is_incremental( c(1,2,5))
  
  is_incremental(1:5, step=NULL)
  is_uniform(1:5)


  is_monotonic( 1:3 )
  is_strictly_monotonic(1:3)
  
  is_monotonic( c(1,3,2) )
  is_strictly_monotonic( c(1,3,2) )
  
  is_sorted(1:3)
  is_sorted(c(1,3,2))   
  
  lets <- letters[1:3]
  is_monotonic( lets )
  is_monotonic( c('a', 'c', 'b') )
  
  is_sorted(1:10)
  
  is_sorted(-5:5)
  is_sorted(5:-5)
  
  is_sorted( letters )
  is_sorted( rev(letters) )
  
}
\seealso{
\itemize{
\item \code{\link[base:diff]{base::diff()}}
}

\itemize{
\item \code{\link[base:is.unsorted]{base::is.unsorted()}}
}
}
