% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opusminer.R
\name{read_transactions}
\alias{read_transactions}
\title{Read Transaction Data from a File (Fast)}
\usage{
read_transactions(filename, sep = " ", format = "list")
}
\arguments{
\item{filename}{A filename.}

\item{sep}{The separator between items (default " ").}

\item{format}{The output format ("list" or "transactions").}
}
\value{
The transaction data, in the form of a list (of transactions, each
list element being a vector of character values representing item labels), or
an object of class \code{\link[arules]{transactions}} (\code{arules}).
}
\description{
\code{read_transactions} reads transaction data from a file fast, providing a
significant speed increase over alternative methods for larger files.
}
\details{
\code{read_transactions} uses (internally) the \code{\link[base]{readChar}}
function to read transaction data from a file fast.  This is substantially
faster for larger files than alternative methods.

Files should be in the format of a list of transactions, one line per
transaction, each transaction (ie, line) being a sequence of item labels,
separated by the character specified by the parameter \code{sep} (default "
").  See, for example, the files at \url{http://fimi.ua.ac.be/data/}.
}
\examples{
\dontrun{

trans <- read_transactions("mushroom.dat")
trans <- read_transactions("mushroom.dat", format = "transactions")
}
}
