% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassTrtSelOptThresh.R
\docType{class}
\name{trtSelOptThresh-class}
\alias{trtSelOptThresh-class}
\alias{trtSelOptThresh}
\title{An S4 class to describe the optimal threshold of a treatment selection marker.}
\description{
An S4 class to describe the optimal threshold of a treatment selection marker.
}
\details{
You never have to create this class manually. This class is created internally when the \code{trtSelThresh} function is used.
}
\section{Slots}{

\describe{
\item{\code{optThresh}}{This slot is an object that takes in argument the sampled optimal threshold values. Numeric argument.}

\item{\code{r0}}{This slot is an object that takes in argument the sampled mean risks of event occurrence in the reference arm. Numeric argument.}

\item{\code{r1}}{This slot is an object that takes in argument the sampled mean risks of event occurrence in the innovative arm. Numeric argument.}

\item{\code{xEvtRef}}{This slot is an object that takes in argument the marker values in the subgroup of patients that developed the event in the reference arm. Numeric argument.}

\item{\code{xNoEvtRef}}{This slot is an object that takes in argument the marker values in the subgroup of patients that did not develop the event in the reference arm. Numeric argument.}

\item{\code{xEvtInnov}}{This slot is an object that takes in argument the marker values in the subgroup of patients that developed the event in the innovative arm. Numeric argument.}

\item{\code{xNoEvtInnov}}{This slot is an object that takes in argument the marker values in the subgroup of patients that did not develop the event in the innovative arm. Numeric argument.}

\item{\code{lowRef}}{This slot is a logical argument that specifies whether the reference treatment is recommended for low values of the marker.}

\item{\code{toxRef}}{This slot is a logical argument that specifies whether the reference treatment is the most toxic treatment option at equal efficacy with the innovative treatment.}

\item{\code{markerBasedRiskRef}}{This slot is an object that takes in argument the sampled mean risks of event occurrence in the reference treatment under the marker-based allocation rule. Numeric argument.}

\item{\code{markerBasedRiskInnov}}{This slot is an object that takes in argument the sampled mean risks of event occurrence in the innovative treatment under the marker-based allocation rule. Numeric argument.}

\item{\code{mcmcChainEvtRef}}{This slot is an object that takes in argument the sampled distribution objects in the subgroup of patients that developed the event in the reference arm. list argument.}

\item{\code{mcmcChainNoEvtRef}}{This slot is an object that takes in argument the sampled distribution objects in the subgroup of patients that did not develop the event in the reference arm. list argument.}

\item{\code{mcmcChainEvtInnov}}{This slot is an object that takes in argument the sampled distribution objects in the subgroup of patients that developed the event in the innovative arm. list argument.}

\item{\code{mcmcChainNoEvtInnov}}{This slot is an object that takes in argument the sampled distribution objects in the subgroup of patients that did not develop the event in the innovative arm. list argument.}

\item{\code{tabMCMCChain}}{This slot is an object that takes in argument all the distribution parameters that were sampled using the MCMC algorithm. mcmc.listOrNull argument.}

\item{\code{paraNamesUserDefined}}{This slot is an object that takes in argument the list of the distribution parameter names defined by the user in a 'fitUserDefinedDist' object. list argument.}

\item{\code{cdfUserDefined}}{This slot is an object that takes in argument the list of cumulative distribution functions defined by the user in 'fitUserDefinedDist' objects. list argument.}

\item{\code{gradientUserDefined}}{This slot is an object that takes in argument the list of gradient functions defined by the user in 'fitUserDefinedDist' objects. list argument.}

\item{\code{hessianUserDefined}}{This slot is an object that takes in argument the list of hessian functions defined by the user in 'fitUserDefinedDist' objects. list argument.}

\item{\code{percentNA}}{This slot is a numeric object that indicates the percentage of NA values contained in the 'optThresh' slot.}
}}

\seealso{
\code{\link[optimalThreshold]{trtSelThresh}} for more details on how to estimate the optimal threshold of a treatment selection marker.
}
