% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassTrtSelOptThresh.R, R/ClassDiagOptThresh.R
\docType{methods}
\name{credibleIntervals}
\alias{credibleIntervals}
\alias{credibleIntervals,trtSelOptThresh-method}
\alias{credibleIntervals.trtSelOptThresh}
\alias{credibleIntervals,diagOptThresh-method}
\alias{credibleIntervals.diagOptThresh}
\title{Credible intervals estimation}
\usage{
credibleIntervals(object, ...)

\S4method{credibleIntervals}{trtSelOptThresh}(object, alpha = 0.05,
  hpd = FALSE)

\S4method{credibleIntervals}{diagOptThresh}(object, alpha = 0.05,
  hpd = FALSE)
}
\arguments{
\item{object}{a \code{trtSelOptThresh} or a \code{diagOptThresh} S4 class object from which the credible intervals of several indicators (including the optimal threshold) must be calculated.}

\item{...}{other arguments passed to the method.}

\item{alpha}{alpha parameter for the confidence level required.}

\item{hpd}{logical value to specify whether the function has to return Highest Posterior Density interval or not.}
}
\value{
Returns a matrix with the credible intervals of several indicators.

Returns the credible intervals of several indicators.
}
\description{
Credible intervals estimation
}
\details{
This function calculates the credible intervals of several indicators depending on the type of marker under study (treatment selection or diagnostic marker). The user may specify the alpha risk for the confidence level (default is 5%), and the method to calculate the credible intervals: percentile (default with \code{hpd = FALSE}) or using the highest posterior density method (with \code{hpd = TRUE}). When \code{hpd = TRUE}, the function \code{hdi} from the \code{HDInterval} package is used.
}
\section{References}{

Gelman, A, et al. 2014. \emph{Bayesian Data Analysis}. 3rd edition, CRC Press, Boca Raton, section 2.3.
}

\seealso{
\code{\link[optimalThreshold]{trtSelThresh}}, \code{\link[optimalThreshold]{diagThresh}}, and \code{\link[HDInterval]{hdi}}.
}
