% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_models.R
\name{ensemble_metrics}
\alias{ensemble_metrics}
\title{Compute ensemble metrics}
\usage{
ensemble_metrics(
  n_top = 0,
  df_params,
  metrics = NULL,
  metrics_exclude = NULL,
  n_models = 10
)
}
\arguments{
\item{n_top}{Threshold of number of models to rank}

\item{df_params}{Output of opticskxi_pipeline}

\item{metrics}{Names of metrics to use. Any of those computed by
opticskxi_pipeline, e.g. 'sindex', 'ch', 'dunn',
'dunn2', 'widestgap', 'entropy' etc.
NULL for all (8).}

\item{metrics_exclude}{Names of metrics to exclude.
Typically used with metrics = NULL. E.g. 'entropy'.}

\item{n_models}{Number of best models to return}
}
\value{
List of metrics' rankings matrix and best models' parameters data
        frame.
}
\description{
Use models' rankings over several metrics to select best model.
Several approaches can be taken to sum the models' rankings, and instead of
summing the ranks of all models over all metrics, we prefer to rank only the
top models for each metrics, and set 0 to all other. This behavior is
controlled by the n_top parameter. In a second step, we sum the ranks and
return only the top models, and this is controlled by the n_models
parameter.
The output is a list of the rankings matrix, for quality control purposes,
and the selected models' parameters data frame, which is used by the
ensemble_models function.
}
