% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency.R
\name{efficiency}
\alias{efficiency}
\title{Efficiency of optimal design}
\usage{
efficiency(
  yyy,
  ip,
  uncert = FALSE,
  ipop,
  oc = "D",
  L = NULL,
  items = FALSE,
  integ = TRUE
)
}
\arguments{
\item{yyy}{a \code{\link{optical}} object; the output of a call \code{\link[=optical]{optical()}}}

\item{ip}{matrix with item parameters for all items (number of rows determines number of items;
number of columns is 2 (for 2PL; or 1PL with common a-parameter when NA in first column from second item)
or 3 (for 3PL; or mixed 2/3-PL with NA for 2PL-items in third column)}

\item{uncert}{if false (default), abilities are assumed to be known; if true,
handling of uncertainties of Bjermo et al. (2021) is used.}

\item{ipop}{matrix with item parameters for operational items
(used if uncert=TRUE, only).}

\item{oc}{optimality criterion: "D" (D-optimality, default),
"I" (I-optimality with standard normal weight function), "A" (A-optimality).}

\item{L}{L-matrix (not used for D-optimality)}

\item{items}{if false (default), only total block efficiency is returned; if true,
criteria for optimal and random and the efficiency
for each item are reported in each column of output. Last column are then
total criteria and efficiency. D-, L-, I-, A-optimality}

\item{integ}{if true (default), integrate() is used for computation of partial
information matrices; if false, Riemann rule is used.}
}
\value{
A numerical value is displayed.
}
\description{
This function computes the efficiency of the D, I, and A optimal designs
compared to the random design.
}
\examples{
# 2PL-models for two items; parameters (a, b)=(1.6, -1) and (1.6, 1), respectively
ip <- cbind(c(1.6, 1.6),c(-1, 1))

yyy <- optical(ip)

# Efficiency of A-optimal design compared to random design
efficiency(yyy, ip, oc="A")

\donttest{
# Efficiency of D-optimal design compared to random design
efficiency(yyy, ip, oc="D")

# Efficiency of I-optimal design compared to random design
efficiency(yyy, ip, oc="I")
}
}
\seealso{
\code{\link{optical}}
}
