% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_manual_locked_constraints.R
\name{add_manual_locked_constraints}
\alias{add_manual_locked_constraints}
\alias{add_manual_locked_constraints,ProjectProblem,data.frame-method}
\alias{add_manual_locked_constraints,ProjectProblem,tbl_df-method}
\title{Add manually specified locked constraints}
\usage{
add_manual_locked_constraints(x, locked)

\S4method{add_manual_locked_constraints}{ProjectProblem,data.frame}(x, locked)

\S4method{add_manual_locked_constraints}{ProjectProblem,tbl_df}(x, locked)
}
\arguments{
\item{x}{\linkS4class{ProjectProblem} object.}

\item{locked}{\code{data.frame} or \code{\link[tibble:tibble]{tibble::tibble()}} object. See
the Details section for more information.}
}
\value{
\linkS4class{ProjectProblem} object with the constraints
added to it.
}
\description{
Add constraints to a project prioritization \code{\link[=problem]{problem()}} to ensure
that solutions fund (or do not fund) specific actions. This function offers
more fine-grained control than the \code{\link[=add_locked_in_constraints]{add_locked_in_constraints()}}
and \code{\link[=add_locked_out_constraints]{add_locked_out_constraints()}} functions.
}
\details{
The argument to \code{locked} must contain the following fields
(columns):

\describe{

\item{\code{"action"}}{\code{character} action name.}

\item{\code{"status"}}{\code{numeric} values indicating if actions should
be funded (with a value of 1) or not (with a value of zero).}

}
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)


# create data frame with locked statuses
status <- data.frame(action = sim_actions$name[1:2],
                     status = c(0, 1))

# print locked statuses
print(status)

# build problem with minimum set objective and targets that require each
# feature to have a 30\% chance of persisting into the future
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
      add_max_richness_objective(budget = 500) \%>\%
      add_manual_locked_constraints(status) \%>\%
      add_binary_decisions()

# print problem
print(p)

\dontrun{
# solve problem
s <- solve(p)

# print solution
print(s)
}

}
\seealso{
\link{constraints}.
}
