% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_reverse.R
\name{oc_reverse_df}
\alias{oc_reverse_df}
\alias{oc_reverse_df.data.frame}
\alias{oc_reverse_df.numeric}
\title{Reverse geocoding with data frames}
\usage{
oc_reverse_df(...)

\method{oc_reverse_df}{data.frame}(
  data,
  latitude,
  longitude,
  bind_cols = TRUE,
  output = c("short", "all"),
  language = NULL,
  min_confidence = NULL,
  roadinfo = FALSE,
  no_annotations = TRUE,
  no_dedupe = FALSE,
  abbrv = FALSE,
  ...
)

\method{oc_reverse_df}{numeric}(
  latitude,
  longitude,
  output = c("short", "all"),
  language = NULL,
  min_confidence = NULL,
  no_annotations = TRUE,
  no_dedupe = FALSE,
  abbrv = FALSE,
  ...
)
}
\arguments{
\item{...}{Ignored.}

\item{data}{A data frame.}

\item{latitude, longitude}{Unquoted variable names of numeric columns or
vectors of latitude and longitude values.}

\item{bind_cols}{When \code{bind_col = TRUE}, the default, the results are column
bound to \code{data}. When \code{FALSE}, the results are returned as a new tibble.}

\item{output}{A character vector of length one indicating whether only the
formatted address (\code{"short"}, the default) or all variables (\code{"all"})
variables should be returned.}

\item{language}{Character vector, or an unquoted variable name of such a
vector, of \href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47 language tags} (such as "es" for
Spanish or "pt-BR" for Brazilian Portuguese). OpenCage will attempt to
return results in that language. Alternatively you can specify the "native"
tag, in which case OpenCage will attempt to return the response in the
"official" language(s). In case the \code{language} parameter is set to \code{NULL}
(which is the default), the tag is not recognized, or OpenCage does not
have a record in that language, the results will be returned in English.}

\item{min_confidence}{Numeric vector of integer values, or an unquoted
variable name of such a vector, between 0 and 10 indicating the precision
of the returned result as defined by its geographical extent, (i.e. by the
extent of the result's bounding box). See the \href{https://opencagedata.com/api#confidence}{API documentation} for details. Only
results with at least the requested confidence will be returned. Default is
\code{NULL}).}

\item{roadinfo}{Logical vector, or an unquoted variable name of such a
vector, indicating whether the geocoder should attempt to match the nearest
road (rather than an address) and provide additional road and driving
information. Default is \code{FALSE}.}

\item{no_annotations}{Logical vector, or an unquoted variable name of such a
vector, indicating whether additional information about the result location
should be returned. \code{TRUE} by default, which means that the results will
not contain annotations.}

\item{no_dedupe}{Logical vector, or an unquoted variable name of such a
vector. Default is \code{FALSE}. When \code{TRUE} the results will not be
deduplicated.}

\item{abbrv}{Logical vector, or an unquoted variable name of such a vector.
Default is \code{FALSE}. When \code{TRUE} addresses in the \code{oc_formatted} variable of
the results are abbreviated (e.g. "Main St." instead of "Main Street").}
}
\value{
A tibble. Column names coming from the OpenCage API are prefixed with
\code{"oc_"}.
}
\description{
Reverse geocoding from latitude and longitude pairs to the names and
addresses of a location.
}
\examples{
\dontshow{if (oc_key_present() && oc_api_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(tibble)
df <- tibble(id = 1:4,
             lat = c(-36.85007, 47.21864, 53.55034, 34.05369),
             lng = c(174.7706, -1.554136, 10.000654, -118.242767))

# Return formatted address of lat/lng values
oc_reverse_df(df, latitude = lat, longitude = lng)

# Return more detailed information about the locations
oc_reverse_df(df, latitude = lat, longitude = lng,
              output = "all")

# Return results in a preferred language if possible
oc_reverse_df(df, latitude = lat, longitude = lng,
              language = "fr")

# oc_reverse_df accepts unquoted column names for all
# arguments except bind_cols and output.
# This makes it possible to build up more detailed queries
# through the data frame passed to the data argument.

df2 <- add_column(df,
                  language = c("en", "fr", "de", "en"),
                  confidence = c(8, 10, 10, 10))

# Use language column to specify preferred language of results
# and confidence column to allow different confidence levels
oc_reverse_df(df2, latitude = lat, longitude = lng,
              language = language,
              min_confidence = confidence)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=oc_reverse]{oc_reverse()}} for inputs as vectors, or \code{\link[=oc_forward]{oc_forward()}} and
\code{\link[=oc_forward]{oc_forward()}} for forward geocoding. For more information about the API
and the various parameters, see the \href{https://opencagedata.com/api}{OpenCage API documentation}.
}
