% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappings.R
\name{MappingsResource}
\alias{MappingsResource}
\title{Mappings Resource}
\value{
Mappings for the concept.

Mapping results with summary.
}
\description{
R6 class providing access to mapping operations.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MappingsResource-new}{\code{MappingsResource$new()}}
\item \href{#method-MappingsResource-get}{\code{MappingsResource$get()}}
\item \href{#method-MappingsResource-map}{\code{MappingsResource$map()}}
\item \href{#method-MappingsResource-print}{\code{MappingsResource$print()}}
\item \href{#method-MappingsResource-clone}{\code{MappingsResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MappingsResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-MappingsResource-new}{}}}
\subsection{Method \code{new()}}{
Create a new MappingsResource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MappingsResource$new(base_req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_req}}{Base httr2 request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MappingsResource-get"></a>}}
\if{latex}{\out{\hypertarget{method-MappingsResource-get}{}}}
\subsection{Method \code{get()}}{
Get mappings for a concept.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MappingsResource$get(
  concept_id,
  target_vocabulary = NULL,
  include_invalid = FALSE,
  vocab_release = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The concept ID.}

\item{\code{target_vocabulary}}{Filter to a specific target vocabulary (e.g., "ICD10CM").}

\item{\code{include_invalid}}{Include invalid/deprecated mappings. Default \code{FALSE}.}

\item{\code{vocab_release}}{Specific vocabulary release version (e.g., "2025.1"). Default \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MappingsResource-map"></a>}}
\if{latex}{\out{\hypertarget{method-MappingsResource-map}{}}}
\subsection{Method \code{map()}}{
Map concepts to a target vocabulary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MappingsResource$map(
  target_vocabulary,
  source_concepts = NULL,
  source_codes = NULL,
  mapping_type = NULL,
  include_invalid = FALSE,
  vocab_release = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target_vocabulary}}{Target vocabulary ID (e.g., "ICD10CM", "SNOMED", "RxNorm").}

\item{\code{source_concepts}}{Vector of OMOP concept IDs to map. Use this OR source_codes, not both.}

\item{\code{source_codes}}{List of vocabulary/code pairs to map. Each element should be a list
with \code{vocabulary_id} and \code{concept_code}. Use this OR source_concepts, not both.}

\item{\code{mapping_type}}{Mapping type filter (direct, equivalent, broader, narrower).}

\item{\code{include_invalid}}{Include invalid mappings. Default \code{FALSE}.}

\item{\code{vocab_release}}{Specific vocabulary release version (e.g., "2025.1"). Default \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MappingsResource-print"></a>}}
\if{latex}{\out{\hypertarget{method-MappingsResource-print}{}}}
\subsection{Method \code{print()}}{
Print resource information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MappingsResource$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MappingsResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MappingsResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MappingsResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
