% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-opIndicators.R
\name{create_op}
\alias{create_op}
\alias{create_op_demo}
\alias{create_op_food}
\alias{create_op_hunger}
\alias{create_op_adl}
\alias{create_op_disability}
\alias{create_op_mental}
\alias{create_op_dementia}
\alias{create_op_health}
\alias{create_op_income}
\alias{create_op_wash}
\alias{create_op_anthro}
\alias{create_op_oedema}
\alias{create_op_screening}
\alias{create_op_visual}
\alias{create_op_misc}
\title{Create older people indicators dataset from survey data collected using the
standard RAM-OP questionnaire.}
\usage{
create_op(
  svy,
  indicators = c("demo", "food", "hunger", "disability", "adl", "mental", "dementia",
    "health", "income", "wash", "anthro", "oedema", "screening", "visual", "misc"),
  sex = c("mf", "m", "f")
)

create_op_demo(svy, sex = c("mf", "m", "f"))

create_op_food(svy, sex = c("mf", "m", "f"))

create_op_hunger(svy, sex = c("mf", "m", "f"))

create_op_adl(svy, sex = c("mf", "m", "f"))

create_op_disability(svy, sex = c("mf", "m", "f"))

create_op_mental(svy, sex = c("mf", "m", "f"))

create_op_dementia(svy, sex = c("mf", "m", "f"))

create_op_health(svy, sex = c("mf", "m", "f"))

create_op_income(svy, sex = c("mf", "m", "f"))

create_op_wash(svy, sex = c("mf", "m", "f"))

create_op_anthro(svy, sex = c("mf", "m", "f"))

create_op_oedema(svy, sex = c("mf", "m", "f"))

create_op_screening(svy, sex = c("mf", "m", "f"))

create_op_visual(svy, sex = c("mf", "m", "f"))

create_op_misc(svy, sex = c("mf", "m", "f"))
}
\arguments{
\item{svy}{A \code{\link[=data.frame]{data.frame()}} collected using the standard RAM-OP
questionnaire.}

\item{indicators}{A character vector of indicator set names. The vector may
include one or more of the following: \emph{"demo"}, \emph{"food"}, \emph{"hunger"},
\emph{"disability"}, \emph{"adl"}, \emph{"mental"}, \emph{"dementia"}, \emph{"health"}, \emph{"income"},
\emph{"wash"}, \emph{"anthro"}, \emph{"oedema"}, \emph{"screening"}, \emph{"visual"}, \emph{"misc"}.
Default is all indicator set names.}

\item{sex}{A character value of \emph{"m"}, \emph{"f"}, or "\emph{mf}" to indicate whether
to report indicators for \emph{males}, \emph{females}, or \emph{both} respectively.
Default is \emph{"mf"} for both sexes.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} of older people indicators.
}
\description{
The indicator sets covered by the standard RAM-OP survey are:
\itemize{
\item Demographic indicators
\item Dietary intake indicators
\item Household hunger scale
\item Katz Index of Independence in Activities of Daily Living score
\item K6 Short form psychological distress score
\item Brief Community Screening Instrument for Dementia (CSID)
\item Health and health-seeking indicators
\item Income and income sources
\item Water, sanitation and hygiene (WASH) indicators
\item Anthropometry and screening
\item Visual impairment by "Tumbling E" method
\item Miscellaneous indicators
\item Washington Group on Disability
}
}
\section{Demographic indicators}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{psu} \tab Primary sampling unit \cr
   \code{resp1} \tab Respondent is SUBJECT \cr
   \code{resp2} \tab Respondent is FAMILY CARER \cr
   \code{resp3} \tab Respondent is OTHER CARER \cr
   \code{resp4} \tab Respondent is OTHER \cr
   \code{age} \tab Age of respondent (years) \cr
   \code{ageGrp1} \tab Age of respondent is between 50 and 59 years \cr
   \code{ageGrp2} \tab Age of respondent is between 60 and 69 years \cr
   \code{ageGrp3} \tab Age of respondent is between 70 and 79 years \cr
   \code{ageGrp4} \tab Age of respondent is between 80 and 89 years \cr
   \code{ageGrp5} \tab Age of respondent is between 90 years and older \cr
   \code{sex1} \tab Male \cr
   \code{sex2} \tab Female \cr
   \code{marital1} \tab Marital status = SINGLE \cr
   \code{marital2} \tab Marital status = MARRIED \cr
   \code{marital3} \tab Marital status = LIVING TOGETHER \cr
   \code{marital4} \tab Marital status = DIVORCED \cr
   \code{marital5} \tab Marital status = SEPARATED \cr
   \code{marital6} \tab Marital status = OTHER \cr
   \code{alone} \tab Respondent lives alone \cr
}
}

\section{Dietary intake indicators}{


These dietary intake indicators have been purpose-built for older people but
the basic approach used is described in:

\cite{Kennedy G, Ballard T, Dop M C (2011). Guidelines for Measuring
Household and Individual Dietary Diversity. Rome, FAO
\url{https://www.fao.org/4/i1983e/i1983e00.htm}}

and extended to include indicators of probable adequate intake of a number of
nutrients / micronutrients.\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{MF} \tab Meal frequency \cr
   \code{DDS} \tab Dietary Diversity Score (count of 11 groups) \cr
   \code{FG01} \tab Cereals \cr
   \code{FG02} \tab Roots and tubers \cr
   \code{FG03} \tab Fruits and vegetables \cr
   \code{FG04} \tab All meat \cr
   \code{FG05} \tab Eggs \cr
   \code{FG06} \tab Fish \cr
   \code{FG07} \tab Legumes, nuts and seeds \cr
   \code{FG08} \tab Milk and milk products \cr
   \code{FG09} \tab Fats \cr
   \code{FG10} \tab Sugar \cr
   \code{FG11} \tab Other \cr
   \code{proteinRich} \tab Protein rich foods \cr
   \code{pProtein} \tab Protein rich plant sources of protein \cr
   \code{aProtein} \tab Protein rich animal sources of protein \cr
   \code{pVitA} \tab Plant sources of vitamin A \cr
   \code{aVitA} \tab Animal sources of vitamin A \cr
   \code{xVitA} \tab Any source of vitamin A \cr
   \code{ironRich} \tab Iron rich foods \cr
   \code{caRich} \tab Calcium rich foods \cr
   \code{znRich} \tab Zinc rich foods \cr
   \code{vitB1} \tab Vitamin B1-rich foods \cr
   \code{vitB2} \tab Vitamin B2-rich foods \cr
   \code{vitB3} \tab Vitamin B3-rich foods \cr
   \code{vitB6} \tab Vitamin B6-rich foods \cr
   \code{vitB12} \tab Vitamin B12-rich foods \cr
   \code{vitBcomplex} \tab Vitamin B1/B2/B3/B6/B12-rich foods \cr
}
}

\section{Household Hunger Scale (HHS)}{


The HHS is described in:

\cite{Ballard T, Coates J, Swindale A, Deitchler M (2011). Household Hunger
Scale: Indicator Definition and Measurement Guide. Washington DC,
FANTA-2 Bridge, FHI 360
\url{https://inddex.nutrition.tufts.edu/data4diets/indicator/household-hunger-scale-hhs}}\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{HHS1} \tab Little or no hunger in household \cr
   \code{HHS2} \tab Moderate hunger in household \cr
   \code{HHS3} \tab Severe hunger in household \cr
}
}

\section{Katz Index of Independence in Activities of Daily Living score}{


The Katz ADL score is described in:

\cite{Katz S, Ford AB, Moskowitz RW, Jackson BA, Jaffe MW (1963). Studies
of illness in the aged. The Index of ADL: a standardized measure of
biological and psychosocial function. JAMA, 1963, 185(12):914-9
\doi{10.1001/jama.1963.03060120024016}}

\cite{Katz S, Down TD, Cash HR, Grotz, RC (1970). Progress in the development
of the index of ADL. The Gerontologist, 10(1), 20-30
\doi{10.1093/geront/10.4_Part_1.274}}

\cite{Katz S (1983). Assessing self-maintenance: Activities of daily living,
mobility and instrumental activities of daily living. JAGS, 31(12),
721-726 \doi{10.1111/j.1532-5415.1983.tb03391.x}}\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{ADL01} \tab Bathing \cr
   \code{ADL02} \tab Dressing \cr
   \code{ADL03} \tab Toileting \cr
   \code{ADL04} \tab Transferring (mobility) \cr
   \code{ADL05} \tab Continence \cr
   \code{ADL06} \tab Feeding \cr
   \code{scoreADL} \tab ADL Score \cr
   \code{classADL1} \tab Severity of dependence 1 \cr
   \code{classADL2} \tab Severity of dependence 2 \cr
   \code{classADL3} \tab Severity of dependence 3 \cr
   \code{hasHelp} \tab Have someone to help with everyday activities \cr
   \code{unmetNeed} \tab Need help but has no helper \cr
}
}

\section{K6 Short form psychological distress score}{


The K6 score is described in:

\cite{Kessler RC, Andrews G, Colpe LJ, Hiripi E, Mroczek, DK, Normand SLT,
et al. (2002). Short screening scales to monitor population prevalences
and trends in non-specific psychological distress. Psychological
Medicine, 32(6), 959–976 \doi{10.1017/S0033291702006074}}\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{K6} \tab K6 score \cr
   \code{K6Case} \tab K6 score > 12  (in serious psychological distress) \cr
}
}

\section{Brief Community Screening Instrument for Dementia (CSID)}{


The CSID dementia screening tool is described in:

\cite{Prince M, et al. (2010). A brief dementia screener suitable for use
by non-specialists in resource poor settings - The cross-cultural
derivation and validation of the brief Community Screening Instrument
for Dementia. International Journal of Geriatric Psychiatry, 26(9),
899–907 \doi{10.1002/gps.2622}}\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{DS} \tab Probable dementia by CSID screen \cr
}
}

\section{Health and health-seeking indicators}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{H1} \tab Chronic condition \cr
   \code{H2} \tab Takes drugs regularly for chronic condition \cr
   \code{H31} \tab No drugs available \cr
   \code{H32} \tab Too expensive / no money \cr
   \code{H33} \tab Too old to look for care \cr
   \code{H34} \tab Use traditional medicine \cr
   \code{H35} \tab Drugs don't help \cr
   \code{H36} \tab No-one to help me \cr
   \code{H37} \tab No need \cr
   \code{H38} \tab Other \cr
   \code{H39} \tab No reason given \cr
   \code{H4} \tab Recent disease episode \cr
   \code{H5} \tab Accessed care for recent disease episode \cr
   \code{H61} \tab No drugs available \cr
   \code{H62} \tab Too expensive / no money \cr
   \code{H63} \tab Too old to look for care \cr
   \code{H64} \tab Use traditional medicine \cr
   \code{H65} \tab Drugs don't help \cr
   \code{H66} \tab No-one to help me \cr
   \code{H67} \tab No need \cr
   \code{H68} \tab Other \cr
   \code{H69} \tab No reason given \cr
}
}

\section{Income and income sources}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{M1} \tab Has a personal income \cr
   \code{M2A} \tab Agriculture / fishing / livestock \cr
   \code{M2B} \tab Wages / salary \cr
   \code{M2C} \tab Sale of charcoal / bricks / etc. \cr
   \code{M2D} \tab Trading (e.g. market or shop) \cr
   \code{M2E} \tab Investments \cr
   \code{M2F} \tab Spending savings / sale of assets \cr
   \code{M2G} \tab Charity \cr
   \code{M2H} \tab Cash transfer / Social security \cr
   \code{M2I} \tab Other \cr
}
}

\section{Water, sanitation and hygiene (WASH) indicators}{


These are a (core) subset of indicators from:

\cite{WHO / UNICEF (2006). Core Questions on Drinking-water and Sanitation
for Household Surveys. Geneva, WHO / UNICEF
\url{https://www.who.int/publications/i/item/9241563265}}\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{W1} \tab Improved source of drinking water \cr
   \code{W2} \tab Safe drinking water (improved source OR adequate treatment) \cr
   \code{W3} \tab Improved sanitation facility \cr
   \code{W4} \tab Improved non-shared sanitation facility \cr
}
}

\section{Anthropometry and screening}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{MUAC} \tab Mid-upper arm circumference (mm) \cr
   \code{oedema} \tab Bilateral pitting oedema (may not be nutritional) \cr
   \code{screened} \tab Either MUAC or oedema checked previously \cr
}
}

\section{Visual impairment by "Tumbling E" method}{


The "Tumbling E" method is described in:

\cite{Taylor HR (1978). Applying new design principles to the construction of
an illiterate E Chart. Am J Optom & Physiol Optics 55:348}\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   poorVA \tab Poor visual acuity (correct in < 3 of 4 tests) \cr
}
}

\section{Miscellaneous indicators}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{chew} \tab Problems chewing food \cr
   \code{food} \tab Anyone in HH receives a ration \cr
   \code{NFRI} \tab Anyone in HH received non-food relief item/s (NFRI) in previous month \cr
}
}

\section{Washington Group on Disability}{


See:

\url{https://www.washingtongroup-disability.com/}

for details.\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \code{wgVisionD0} \tab Vision domain 0 \cr
   \code{wgVisionD1} \tab Vision domain 1 \cr
   \code{wgVisionD2} \tab Vision domain 2 \cr
   \code{wgVisionD3} \tab Vision domain 3 \cr
   \code{wgHearingD0} \tab Hearing domain 0 \cr
   \code{wgHearingD1} \tab Hearing domain 1 \cr
   \code{wgHearingD2} \tab Hearing domain 2 \cr
   \code{wgHearingD3} \tab Hearing domain 3 \cr
   \code{wgMobilityD0} \tab Mobility domain 0 \cr
   \code{wgMobilityD1} \tab Mobility domain 1 \cr
   \code{wgMobilityD2} \tab Mobility domain 2 \cr
   \code{wgMobilityD3} \tab Mobility domain 3 \cr
   \code{wgRememberingD0} \tab Remembering domain 0 \cr
   \code{wgRememberingD1} \tab Remembering domain 1 \cr
   \code{wgRememberingD2} \tab Remembering domain 2 \cr
   \code{wgRememberingD3} \tab Remembering domain 3 \cr
   \code{wgSelfCareD0} \tab Self-care domain 0 \cr
   \code{wgSelfCareD1} \tab Self-care domain 1 \cr
   \code{wgSelfCareD2} \tab Self-care domain 2 \cr
   \code{wgSelfCareD3} \tab Self-care domain 3 \cr
   \code{wgCommunicatingD0} \tab Communication domain 0 \cr
   \code{wgCommunicatingD1} \tab Communication domain 1 \cr
   \code{wgCommunicatingD2} \tab Communication domain 2 \cr
   \code{wgCommunicatingD3} \tab Communication domain 3 \cr
   \code{wgP0} \tab Overall 0 \cr
   \code{wgP1} \tab Overall 1 \cr
   \code{wgP2} \tab Overall 2 \cr
   \code{wgP3} \tab Overall 3 \cr
   \code{wgPM} \tab Any disability \cr
}
}

\examples{
# Create indicators dataset from RAM-OP survey data collected from
# Addis Ababa, Ethiopia
create_op(testSVY)
create_op(testSVY, indicators = "demo")
create_op(testSVY, indicators = "hunger", sex = "m")

}
