% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oii_freq.R
\name{oii.freq}
\alias{oii.freq}
\title{Frequency tables}
\usage{
oii.freq(x)
}
\arguments{
\item{x}{input variable, (usually of class \code{\link{factor}})}
}
\value{
A \code{\link{data.frame}} with one row per each unique value of \code{x}.
These values of \code{x} are assigned to the \code{row.names} of the data.frame.
The data.frame also has rows for:
\item{Valid Total}{The total number of non-missing cases (i.e., \code{sum(!is.na(x))})}
\item{Missing}{The total number of missing/NA cases (i.e., \code{sum(is.na(x))})}
\item{Total}{The total number of cases (i.e., \code{length(x)})}

The data.frame has the following columns:
\item{freq}{The number of cases with this value}
\item{percent}{The percentage of all cases that this value represents}
\item{valid_percent}{The percentage of all valid (i.e., not missing) cases that this value represents}
\item{cum_percent}{The cumulative percentage of valid cases}
}
\description{
This function prints a simple frequency table
with totals and percentages
}
\examples{
#Create var as 200 A's, B's, and C's
var<-sample(LETTERS[1:3],size=200,replace=TRUE)

#Generate a frequency table for the counts of A's, B's, and C's
oii.freq(var)

}
\seealso{
\code{\link{data.frame}}, \code{\link{row.names}}
\code{\link{is.na}},  \code{\link{length}}, \code{\link{summary}}, \code{\link{table}}
}
