% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ohvbd-package.R
\docType{package}
\name{ohvbd-package}
\alias{ohvbd-package}
\alias{ohvbd}
\title{ohvbd: One Health VBD Hub}
\description{
Interface with the One Health VBD Hub and related repositories directly.
}
\section{Introduction}{

ohvbd is a data location and ingestion package focused around a series of
vector-borne disease databases. It aims to make it quick and easy to
repeatably download data from a variety of sources without having to navigate
online tools and pages.
}

\section{Searching}{

ohvbd can be used to search a multitude of databases using the \verb{search_*} family of functions.

Most prominent of these is the \code{\link[=search_hub]{search_hub()}} function, which leverages the
<vbdhub.org> search functionality to provide enhanced searches across databases.

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Search hub for the Castor Bean Tick
search_hub("Ixodes ricinus")
}\if{html}{\out{</div>}}

Other dedicated search functionality is available for select databases (e.g. \code{\link[=search_vt_smart]{search_vt_smart()}}).
}

\section{Downloading}{

Once relevant data has been identified, these can be downloaded using the \code{\link[=fetch]{fetch()}} function.

This is typically performed using a piped approach:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Find and retrieve tick data from VecTraits
ixodes_results <- search_hub("Ixodes ricinus", db = "vt") |>
                    fetch()
}\if{html}{\out{</div>}}
}

\section{Parsing & Filtering}{

Downloaded data is simply stored as the responses from the website.

To use the information itself we must use \code{\link[=glean]{glean()}} to extract the relevant data:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Find and retrieve tick data from VecTraits
ixodes_data <- search_hub("Ixodes ricinus", db = "vt") |>
                 fetch() |>
                 glean()
}\if{html}{\out{</div>}}
}

\section{Associating with other data}{

Downloaded data can be associated with climatic variables from AREAData using the \verb{assoc_*} functions.

\if{html}{\out{<div class="sourceCode">}}\preformatted{ixodes_data <- search_hub("Ixodes ricinus", "vt") |>
  tail(20) |>
  fetch() |>
  glean(cols = c(
    "DatasetID",
    "Latitude",
    "Longitude",
    "Interactor1Genus",
    "Interactor1Species"
  ), returnunique = TRUE)
areadata <- fetch_ad(metric="temp", gid=0, use_cache=TRUE)
ad_extract_working <- assoc_ad(ixodes_data, areadata,
                               targetdate = c("2021-08-04"),
                               enddate=c("2021-08-06"),
                               gid=0,
                               lonlat_names = c("Longitude", "Latitude"))

}\if{html}{\out{</div>}}
}

\section{Further information}{

The ohvbd homepage is at \url{https://ohvbd.vbdhub.org}.
See especially the documentation section. Join the discussion forum at
\url{https://forum.vbdhub.org/c/ohvbd-r-package/} if you have questions or comments.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/fwimp/ohvbd}
  \item \url{https://ohvbd.vbdhub.org}
  \item Report bugs at \url{https://github.com/fwimp/ohvbd/issues}
}

}
\author{
\strong{Maintainer}: Francis Windram \email{francis.windram17@imperial.ac.uk} (\href{https://orcid.org/0000-0002-2129-826X}{ORCID}) [copyright holder]

}
\keyword{internal}
