% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glean_ad.R
\name{glean_ad}
\alias{glean_ad}
\title{Extract data from AREAdata datasets}
\usage{
glean_ad(
  ad_matrix,
  targetdate = NA,
  enddate = NA,
  places = NULL,
  gid = NULL,
  printbars = TRUE
)
}
\arguments{
\item{ad_matrix}{A matrix or \code{ohvbd.ad.matrix} of data from AREAdata.}

\item{targetdate}{\strong{ONE OF} the following:
\itemize{
\item The date to search for in ISO 8601 (e.g. "2020", "2021-09", or "2022-09-21").
\item The start date for a range of dates.
\item A character vector of fully specified dates to search for (i.e. "yyyy-mm-dd")
}}

\item{enddate}{The (exclusive) end of the range of dates to search for. If this is unfilled, only the \code{targetdate} is searched for.}

\item{places}{A character vector or single string describing what locality to search for in the dataset.}

\item{gid}{The spatial scale of the AREAdata matrix (this is not needed if the matrix has been supplied by \code{\link[=fetch_ad]{fetch_ad()}}).}

\item{printbars}{Whether to print time overlap bars in the case of dates outside the data range.}
}
\value{
An \code{ohvbd.ad.matrix} or a named vector containing the extracted data.
}
\description{
Extract the data returned by a call to \code{\link[=fetch_ad]{fetch_ad()}}, filter columns of interest and by dates of interest.

Currently this does not handle Population Density or Forecast matrices, however the other 5 metrics are handled natively.
}
\section{Place matching}{

This function attempts to intelligently infer place selections based upon the provided gid and place names.

So if you have an AREAdata dataset at \code{gid=1}, and provide country names, the function will attempt to match those country names and retrieve any GID1-level data that is present.

Occasionally (such as in the case of "Albania", the municipality in La Guajira, Columbia) the name of a place may occur in locations other than those expected by the researcher.

Unfortunately this is not an easy problem to mitigate, and as such it is worthwhile checking the output of this function to make sure it is as you expect.
}

\section{Date ranges}{

The date range is a partially open interval. That is to say the lower bound (\code{targetdate}) is inclusive, but the upper bound (\code{enddate}) is exclusive.

For example a date range of "2020-08-04" - "2020-08-12" will return the 7 days from the 4th through to the 11th of August, but \emph{not} the 12th.
}

\section{Date inference}{


In cases where a full date is not provided, the earliest date possible with the available data is chosen.

So "2020-04" will internally become "2020-04-01".

If an incomplete date is specified as the \code{targetdate} and no \code{enddate} is specified, the range to search is inferred from the minimum temporal scale provided in \code{targetdate}.

For example "2020-04" will be taken to mean the month of April in 2020, and the \code{enddate} will internally be set to "2020-05-01".
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# All dates in August 2022
fetch_ad("temp", gid=0) |>
  glean_ad(
    targetdate = "2022-08",
    places = c("Albania", "Thailand")
  )

# 4th, 5th, and 6th of August 2022 (remember the enddate is EXCLUSIVE)
fetch_ad("temp", gid=0) |>
  glean_ad(
    targetdate = "2022-08-04", enddate="2022-08-07",
    places = c("Albania", "Thailand")
  )

# 4th of August 2022 and 1st of August 2023
fetch_ad("temp", gid=0) |>
  glean_ad(
    targetdate = c("2022-08-04", "2023-08-01"),
    places = c("Albania", "Thailand")
  )
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{areadata}
