% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{force_db}
\alias{force_db}
\title{Force an object to appear to come from a specific database}
\usage{
force_db(x, db)
}
\arguments{
\item{x}{Object to force.}

\item{db}{Database to apply to \code{x}.}
}
\value{
Object with the "db" attribute set to \code{db}
}
\description{
Force an object to appear to come from a specific database
}
\note{
\strong{DO NOT} use this function to create ids to feed into \code{\link[=fetch]{fetch()}}!

Objects created in this way may lack vital underlying data required later.
Instead use \code{\link[=ohvbd.ids]{ohvbd.ids()}} for this purpose.

This is a synonym for \code{ohvbd_db(x) <- db} that's easier to work with in pipelines.
}
\examples{
force_db(c(1,2,3), "vt")

}
\seealso{
\link[=ohvbd_attrs]{Internal attributes}
}
\author{
Francis Windram
}
\concept{convenience}
