% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_vd_meta.R
\name{fetch_vd_counts}
\alias{fetch_vd_counts}
\title{Fetch VecDyn dataset length by ID}
\usage{
fetch_vd_counts(
  ids,
  page_size = 50,
  cache_location = NULL,
  refresh_cache = FALSE,
  noprogress = FALSE,
  basereq = vb_basereq()
)
}
\arguments{
\item{ids}{a numeric ID or numeric vector of ids (preferably in an \code{ohvbd.ids} object) indicating the particular dataset/s to download.}

\item{page_size}{the page size returned by VecDyn (default is 50).}

\item{cache_location}{path to cache location (defaults to a temporary user directory, or one set by \code{\link[=set_default_ohvbd_cache]{set_default_ohvbd_cache()}}).}

\item{refresh_cache}{force a refresh of the relevant cached data.}

\item{noprogress}{disable non-essential messaging (progress bars etc.).}

\item{basereq}{an \link[httr2:request]{httr2 request} object, as generated by \code{\link[=vb_basereq]{vb_basereq()}}. If \code{NA}, uses the default request.}
}
\value{
A dataframe describing the number of rows and number of pages for the set of ids.
}
\description{
Retrieve length of VecDyn dataset/s specified by their dataset ID.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_vd_counts(54)

fetch_vd_counts(c(423,424,425))
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{vecdyn}
