% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_glean_vt_chunked.R
\name{fetch_glean_vt_chunked}
\alias{fetch_glean_vt_chunked}
\title{Get and parse multiple VecTraits datasets by ID in chunks}
\usage{
fetch_glean_vt_chunked(
  ids,
  chunksize = 20,
  cols = NULL,
  returnunique = FALSE,
  rate = 5,
  connections = 2,
  basereq = vb_basereq()
)
}
\arguments{
\item{ids}{a numeric vector of IDs (preferably in an \code{ohvbd.ids} object) indicating the particular datasets to download.}

\item{chunksize}{an integer defining the size of chunks to retrieve in one iteration.}

\item{cols}{a character vector of columns to extract from the dataset.}

\item{returnunique}{whether to return only the unique rows within each dataset according to the filtered columns.}

\item{rate}{maximum number of calls to the API per second.}

\item{connections}{number of simultaneous connections to the server at once. Maximum 8. \strong{Do not enable unless you really need to} as this hits the server significantly harder than usual.}

\item{basereq}{an \link[httr2:request]{httr2 request} object, as generated by \code{\link[=vb_basereq]{vb_basereq()}}. If \code{NA}, uses the default request.}
}
\value{
An \code{ohvbd.data.frame} containing the requested data.
}
\description{
Retrieve and parse VecTraits datasets specified by their dataset IDs in batches.

This is not usually necessary (generally you just need \code{\link[=fetch_vt]{fetch_vt()}}) but allows one to release data that is not in use from memory. If you would like more control on extraction or parsing then it is best to wrap \code{\link[=fetch_vt]{fetch_vt()}} and \code{\link[=glean_vt]{glean_vt()}} in your own chunker instead.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_glean_vt_chunked(c(54,55,56), chunksize = 2, rate=5)
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{vectraits}
