% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak_range.R
\name{PeakRange}
\alias{PeakRange}
\title{Peak Ranges Selection}
\usage{
PeakRange(score, tolerance = 1, point_max = 5)
}
\arguments{
\item{score}{The score data to peak ranges.}

\item{tolerance}{The tolerance level , the selected narrow ranges are with score at least S-tolerance}

\item{point_max}{The largest candidate number of change points.}
}
\value{
\item{n_peak_range}{The number of peak ranges.}
        \item{peak_range}{The location of peak ranges.}
}
\description{
Select the narrow peak ranges.
}
\details{
For each column(window type), find the union of all the peak
ranges whose associated scores are no less than S - tolerance, where S is highest score,
then choose the largest window type with that the number of peak ranges meet the restriction.
}
\references{
J. Ding, Y. Xiang, L. Shen, and V. Tarokh, \emph{Multiple Change Point Analysis:
Fast Implementation and Strong Consistency}. IEEE Transactions on Signal
Processing, vol. 65, no. 17, pp. 4495-4510, 2017.
}
