% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hal_facet.R
\docType{methods}
\name{hal_facet}
\alias{hal_facet}
\alias{hal_facet.HALQuery}
\title{Facet Search}
\usage{
hal_facet(query, ...)

\method{hal_facet}{HALQuery}(
  query,
  field = NULL,
  limit = 5,
  sort = c("count", "index"),
  prefix = NULL,
  contains = NULL,
  pivot = NULL,
  range = NULL,
  ignore_case = FALSE,
  ...
)
}
\arguments{
\item{query}{An object of class \code{HALQuery} (typically returned by \code{\link[=hal_query]{hal_query()}}).}

\item{...}{Currently not used.}

\item{field}{A \code{\link{character}} string specifying the field to group by.}

\item{limit}{An \code{\link{integer}} giving the maximum number of results per group.}

\item{sort}{A \code{\link{character}} string specifying the field to be used to sort
the results.}

\item{prefix}{A \code{\link{character}} string.}

\item{contains}{A \code{\link{character}} string.}

\item{pivot}{A \code{\link{character}} string.}

\item{range}{A \code{\link{list}} containing the following components: "\code{range}",
"\code{start}", "\code{end}", "\code{gap}".}

\item{ignore_case}{A \code{\link{logical}} scalar: should character case be ignored?}
}
\value{
An object of class \code{\link[=hal_query]{HALQuery}}.
}
\description{
Facet Search
}
\examples{
\dontrun{
## Get the number of archaeological document by journal
hal_query("archéologie") |>
  hal_facet(field = "journalTitle_s", sort = "count", decreasing = TRUE) |>
  hal_search() |>
  as.data.frame()

## Get the number of documents per year
hal_query("archéologie") |>
  hal_facet(
    sort = "count",
    range = list(
      field = "producedDateY_i",
      start = 2000,
      end = 2020,
      gap = 1
    )
  ) |>
  hal_search() |>
  as.data.frame()
}
}
\seealso{
Other query tools: 
\code{\link{hal_filter}()},
\code{\link{hal_group}()},
\code{\link{hal_query}()},
\code{\link{hal_select}()},
\code{\link{hal_sort}()},
\code{\link{operators}}
}
\author{
N. Frerebeau
}
\concept{query tools}
