% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{lookWithin}
\alias{lookWithin}
\title{Look Within the First Element of a List for Replacement Values}
\usage{
lookWithin(list)
}
\arguments{
\item{list}{A list of elements, typically arguments that will be used in sw functions.}
}
\value{
A list with elements of the same names but possibly filled in from the first element.
}
\description{
This is a helper function used by some seawater functions
(with names starting with \code{sw}) to
facilitate the specification of water properties either with
distinct arguments, or with data stored within an \code{oce}
object that is the first argument.
}
\details{
If \code{list[1]} is not an \code{oce} object, then the
return value of \code{lookWithin} is the same as the input
value, except that (a) \code{eos} is completed to either
\code{"gsw"} or \code{"unesco"} and (b) if \code{longitude}
and \code{latitude} are within \code{list[1]}, then they
are possibly lengthened, to have the same length as the first
item in the \code{data} slot of \code{list[1]}.

The examples may clarify this somewhat.
}
\examples{
# 1. If first item is not a CTD object, just return the input
lookWithin(list(a = 1, b = 2)) # returns a list
# 2. Extract salinity from a CTD object
data(ctd)
str(lookWithin(list(salinity = ctd)))
# 3. Extract salinity and temperature. Note that the
# value specified for temperature is ignored; all that matters
# is that temperature is named.
str(lookWithin(list(salinity = ctd, temperature = NULL)))
# 4. How it is used by swRho()
rho1 <- swRho(ctd, eos = "unesco")
rho2 <- swRho(ctd[["salinity"]], ctd[["temperature"]], ctd[["pressure"]], eos = "unesco")
stopifnot(all.equal(rho1, rho2))
}
