% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{obm_sql_query}
\alias{obm_sql_query}
\title{SQL Interface}
\usage{
obm_sql_query(
  sqlcmd,
  username = "",
  password = "",
  paranoid = TRUE,
  port = 5432,
  database = "gisdata"
)
}
\arguments{
\item{sqlcmd}{a valid SQL command}

\item{username}{most probably automatically set by create_pg_user module}

\item{password}{most probably automatically set by create_pg_user module}

\item{paranoid}{password prompt type}

\item{port}{postgres server port, default is 5432}

\item{database}{remote database name, default is gisdata}
}
\value{
sql data object or boolean
}
\description{
It is a simple SQL Query interface function
}
\examples{
\donttest{
obm_sql_query("SELECT DATE_PART('day', enddate::timestamp - startdate::timestamp) AS days 
               FROM nestboxes WHERE enddate IS NOT NULL AND startdate IS NOT NULL 
               ORDER BY days")
}
}
\keyword{postgres}
