% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{obm_refresh_token}
\alias{obm_refresh_token}
\title{Refresh an expired OBM access token}
\usage{
obm_refresh_token(
  token = NULL,
  url = get_obm("token_url"),
  client_id = get_obm("client_id", "R"),
  verbose = FALSE
)
}
\arguments{
\item{token}{Optional explicit refresh token (defaults to stored one)}

\item{url}{OAuth2 token endpoint URL (from obm_init())}

\item{client_id}{OAuth2 client identifier ("R" by default)}

\item{verbose}{Print HTTP and token details}
}
\value{
Logical TRUE if token refreshed successfully, FALSE otherwise
}
\description{
This function requests a new access token using the stored refresh token.
It should normally be called internally by other OBM functions when
the current token has expired.
}
\examples{
\donttest{
obm_refresh_token(token='ABCD1234')
}
}
