% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_runs.R
\name{runs_modify_run_request}
\alias{runs_modify_run_request}
\title{API runs: modify run}
\usage{
runs_modify_run_request(
  thread_id,
  run_id,
  metadata = NULL,
  api_key = api_get_key()
)
}
\arguments{
\item{thread_id}{string, the ID of the thread (https://platform.openai.com/docs/api-reference/threads) that was run}

\item{run_id}{string, the ID of the run to modify}

\item{metadata}{NULL/list, set of 16 key-value pairs that can be attached to an object. This can be useful for
storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long
and values can be a maximum of 512 characters long.}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Modifies a run. To get more details, visit
https://platform.openai.com/docs/api-reference/runs/modifyRun
https://platform.openai.com/docs/assistants
}
