% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentTranscripts.R
\name{fragmentTranscripts}
\alias{fragmentTranscripts}
\title{Gets transcript fragments in a given format.}
\usage{
fragmentTranscripts(
  matches,
  layer.ids,
  mime.type = "text/praat-textgrid",
  path = "",
  start.column = Line,
  end.column = LineEnd,
  labbcat.url = NULL
)
}
\arguments{
\item{matches}{A dataframe returned by \link{getMatches} or \link{getAllUtterances}, identifying
the results to which acoustic measurments should be appended.}

\item{layer.ids}{A vector of layer IDs.}

\item{mime.type}{Optional content-type - "text/praat-textgrid" is the default, but your
LaBB-CAT installation may support other formats, which can be discovered using
\link{getSerializerDescriptors}.}

\item{path}{Optional path to directory where the files should be saved.}

\item{start.column}{The column of \code{matches} containing the start time in seconds.}

\item{end.column}{The column of \code{matches} containing the end time in seconds.}

\item{labbcat.url}{URL to the LaBB-CAT instance (instead of inferring it from \code{matches}).}
}
\value{
\code{matches} with the acoustic measurements appended as new columns.
}
\description{
This is a version of \link{getFragments} that can have a
dataframe of matches piped into it.
}
\details{
It gets fragments of transcripts from LaBB-CAT,
converted to a given file format (by default, Praat TextGrid).

\strong{NB} Although many formats will generate exactly one file for each interval
(e.g. mime.type=text/praat-textgrid), this is not guaranteed; some formats generate
a single file or a fixed collection of files regardless of how many fragments there are.
}
\examples{
\dontrun{
## Get all tokens of "the"
the.tokens <- getMatches(labbcat.url, "the")
## Get a TextGrid for each matched utterance, including word and segment intervals
the.textgrids <- the.tokens |> fragmentTranscripts(c("utterance", "word", "segment"))
## Get a CSV for the same utterances
the.textgrids <- the.tokens |> fragmentTranscripts(
    c("utterance", "word", "segment"), mime.type = "text/csv", path="csv")
}
}
\seealso{
\itemize{
\item \link{processWithPraat}
\item \link{getMatches}
}

Other Praat-related functions: 
\code{\link{appendFromPraat}()},
\code{\link{fragmentLabels}()},
\code{\link{praatScriptCentreOfGravity}()},
\code{\link{praatScriptFastTrack}()},
\code{\link{praatScriptFormants}()},
\code{\link{praatScriptIntensity}()},
\code{\link{praatScriptPitch}()},
\code{\link{processWithPraat}()}
}
\concept{Praat-related functions}
\keyword{praat}
