% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNPJ.R, R/CPF.R, R/RENAVAN.R, R/numbersBR.R
\name{format.CNPJ}
\alias{format.CNPJ}
\alias{format.CPF}
\alias{format.RENAVAN}
\alias{format}
\title{Format numbers}
\usage{
\method{format}{CNPJ}(x, format = c("strict", "stripped"), ...)

\method{format}{CPF}(x, format = c("strict", "stripped"), ...)

\method{format}{RENAVAN}(x, ...)
}
\arguments{
\item{x}{the identification number class.}

\item{format}{can be strict which is the default format with all dots, dashes and hyphens or
stripped which returns only the numbers.}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
A character vector with the formatted number.
}
\description{
Formats the brazilian numbers according to their specific format.
}
\examples{
x <- CNPJ(66670000100)
format(x)
format(x, "stripped")
x <- CPF(1239157673)
format(x)
format(x, "stripped")
x <- RENAVAN("68194359406")
format(x)
}
