% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnm.R
\name{loglik}
\alias{loglik}
\title{Log-likelihood value of a mixture}
\usage{
loglik(mix, x, beta = NULL, attr = FALSE)
}
\arguments{
\item{mix}{a discrete distribution, as defined by class
\code{disc}.}

\item{x}{a data object of a mixture model class.}

\item{beta}{the structural parameter, if any.}

\item{attr}{=FALSE, by default. If TRUE, also returns attributes
"dmix" and "logd"}
}
\value{
the log-likelihood value.
}
\description{
Computes the log-likelihood value

\code{x} must belong to a mixture family, as specified by its class.
}
\examples{

## Poisson mixture
mix0 = disc(c(1,4), c(0.7,0.3))
x = rnppois(10, mix0)
loglik(mix0, x)

## Normal mixture
x = rnpnorm(10, mix0, sd=2)
loglik(mix0, x, 2)

}
\references{
Wang, Y. (2007). On fast computation of the non-parametric maximum
likelihood estimate of a mixing distribution. \emph{Journal of the
Royal Statistical Society, Ser. B}, \bold{69}, 185-198.

Wang, Y. (2010). Maximum likelihood computation for fitting
semiparametric mixture models. \emph{Statistics and Computing},
\bold{20}, 75-86
}
\seealso{
\code{\link{cnm}}, \code{\link{cnmms}},
  \code{\link{npnorm}}, \code{\link{nppois}}, \code{\link{disc}},
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
