% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R
\name{nse.andrews}
\alias{nse.andrews}
\title{Andrews estimator}
\usage{
nse.andrews(
  x,
  type = c("bartlett", "parzen", "tukey", "qs", "trunc"),
  lag.prewhite = 0,
  approx = c("AR(1)", "ARMA(1,1)")
)
}
\arguments{
\item{x}{A numeric vector.}

\item{type}{The type of kernel used among which \code{"bartlett"}, \code{"parzen"}, \code{"qs"}, \code{"trunc"} and \code{"tukey"}. Default is \code{type = "bartlett"}.}

\item{lag.prewhite}{Prewhite the series before analysis (integer or \code{NULL}). When \code{lag.prewhite = NULL} this performs automatic lag selection. Default is \code{lag.prewhite = 0} that is no prewhitening.}

\item{approx}{Andrews approximation, either \code{"AR(1)"} or \code{"ARMA(1,1)"}. Default is \code{approx = "AR(1)"}.}
}
\value{
The NSE estimator.
}
\description{
Function which calculates the numerical standard error with the kernel
based variance estimator by Andrews (1991).
}
\details{
This kernel based variance estimation apply weight to the auto-covariance function with a kernel and sums up the value.
}
\note{
\code{nse.andrews} is a wrapper around \code{\link[sandwich]{lrvar}} from the \pkg{sandwich} package and uses Andrews (1991) automatic bandwidth estimator. See the documentation of \pkg{sandwich} for details.
}
\examples{
\dontrun{
n    = 1000
ar   = 0.9
mean = 1
sd   = 1

set.seed(1234)
x = c(arima.sim(n = n, list(ar = ar), sd = sd) + mean)

nse.andrews(x = x, type = "parzen", lag.prewhite = 0)
nse.andrews(x = x, type = "tukey", lag.prewhite = 1)
nse.andrews(x = x, type = "qs", lag.prewhite = NULL)
}
}
\references{
Andrews, D.W.K. (1991).
Heteroskedasticity and autocorrelation consistent covariance matrix estimation.
\emph{Econometrica} \bold{59}(3),  817-858.

Andrews, D.W.K, Monahan, J.C. (1992).
An improved heteroskedasticity and autocorrelation consistent covariance matrix estimator.
\emph{Econometrica} \bold{60}(4),  953-966.

Newey, W.K., West, K.D. (1987).
A simple, positive semi-definite, heteroskedasticity and autocorrelationconsistent covariance matrix.
\emph{Econometrica} \bold{55}(3),  703-708.

Newey, W.K., West, K.D. (1994) .
Automatic lag selection in covariance matrix estimation.
\emph{Review of Economic Studies} \bold{61}(4),  631-653.
}
\author{
David Ardia and Keven Bluteau
}
