% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.frfast.R
\name{summary.frfast}
\alias{summary.frfast}
\alias{print.frfast}
\title{Summarizing fits of \code{frfast} class}
\usage{
\method{summary}{frfast}(object = model, ...)
}
\arguments{
\item{object}{a fitted \code{frfast} object as produced by \code{frfast()}.}

\item{\ldots}{additional arguments affecting the predictions produced.}
}
\value{
\code{summary.frfast} computes and returns a list of summary 
information for a fitted \code{frfast} object.
\item{model}{type of model: nonparametric or allometric.}
\item{smooth}{type of smoother: kernel or splines.}
\item{h}{the kernel bandwidth smoothing parameter.}
\item{dp}{degree of the polynomial.}
\item{nboot}{number of bootstrap repeats.}
\item{kbin}{number of binning nodes over which the function is to be estimated.}
\item{n}{sample size.}
\item{fmod}{factor's levels.}
\item{coef}{if \code{model = "allo"}, coefficients of the model.}
}
\description{
Takes a fitted \code{frfast} object produced by \code{frfast()}
and produces various useful summaries from it.
}
\details{
\code{print.frfast} tries to be smart about \code{summary.frfast}.
}
\examples{
library(npregfast)
data(barnacle)

# Nonparametric regression without interactions
fit <- frfast(DW ~ RC, data = barnacle, nboot = 100) 
fit
summary(fit)

# Nonparametric regression with interactions
fit2 <- frfast(DW ~ RC : F, data = barnacle, nboot = 100)
fit2
summary(fit2)

# Allometric model
fit3 <- frfast(DW ~ RC, data = barnacle, model = "allo", nboot = 100)
fit3
summary(fit3)

}
\references{
Sestelo, M. (2013). Development and computational implementation of 
estimation and inference methods in flexible regression models. 
Applications in Biology, Engineering and Environment. PhD Thesis, Department
of Statistics and O.R. University of Vigo.

Sestelo, M., Villanueva, N.M., Meira-Machado, L., Roca-Pardinas, J. (2017). 
npregfast: An R Package for Nonparametric Estimation and Inference in Life 
Sciences. Journal of Statistical Software, 82(12), 1-27.
}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
