% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-pwr2n.NPH.R
\name{plot.NPHpwr}
\alias{plot.NPHpwr}
\title{Graphical Display of Design Parameters in Sample Size
Calculation}
\usage{
\method{plot}{NPHpwr}(x, type = c("hazard", "survival", "dropout", "event", "censor"), ...)
}
\arguments{
\item{x}{object of the \code{pwr2n.NPH} function}

\item{type}{a vector of string, specifying the graphs to display. The options
include "\code{hazard}", "\code{survival}", "\code{dropout}",
"\code{event}", and
"\code{censor}". If \code{type} is not provided, all the available graphs are
generated.}

\item{...}{additional graphical arguments passed to the plot function}
}
\value{
plots are produced on the current graphics device
}
\description{
Displays graphs of survival, hazards, drop-out and censor over time
as specified in the calculation.
}
\details{
The \code{type} argument provides five options to visualize the trial in design.
Option \code{survival} shows the survival probabilities of treatment and control
group over time. Option \code{hazard} provides the hazard rates and hazard ratio
over time. Option \code{dropout} shows the proportion of drop-out subjects across
the trial duration.
Option \code{censor} shows the proportion of censored subjects over time.
}
\examples{
 # generate weight function
 wlr <- gen.wgt(method = "LR" )
 t_enrl <- 12; t_fup <- 18; lmd0 <- log(2)/12
 # delayed treatment effects, the crossign point is at 6.
 f_hr_delay <- function(x){(x<=6)+(x>6)*0.75}
 f_haz0 <- function(x){lmd0*x^0}
 snph1 <- pwr2n.NPH(entry = t_enrl, fup = t_fup, Wlist = wlr,
                    k = 100, ratio = 2, CtrlHaz = f_haz0,
                    hazR = f_hr_delay)
 # display the hazards plot only
 plot(snph1, type="hazard")
 # display all plots
 plot(snph1)
}
\seealso{
\code{\link{pwr2n.NPH}}
}
