% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typevar.R
\name{type_variable}
\alias{type_variable}
\alias{type_custom}
\alias{type_real}
\alias{type_positive}
\alias{type_negative}
\title{Functions for defining the types of variables}
\usage{
type_custom(
  type = "custom",
  init = c(0, 10),
  randomXj = function(n, v) {     rnorm(n, v[1], v[2]) },
  x2v = function(x) {     c(mean(x), sd(x)) },
  v2x = function(v) {     v[1] },
  smooth = list(quote(smooth_lin(x, xt, 1)), quote(smooth_dec(x, xt, 0.9, 10))),
  ...
)

type_real(...)

type_positive(...)

type_negative(...)
}
\arguments{
\item{type}{label for identifying the type of variable. The name is not
used internally in any case.}

\item{init}{\code{numeric} vector of starting values of parameters of the
sampling distribution.}

\item{randomXj}{function for randomly generating variable values according
to the sampling distribution. The function should take the number of
observations to be generated as a first argument, and the vector of
parameters as a second argument; a vector of random values should be
returned.}

\item{x2v}{function for updating the parameters of the sampling distribution.
\emph{No smoothing is needed.} The function should take a single argument to be
used for updating the parameters.}

\item{v2x}{function for obtaining point values of variable from the
parameters of the sampling distribution.}

\item{smooth}{list of unevaluated expressions of smoothing functions for each
parameter of the sampling distribution.}

\item{...}{further arguments to be included into the \code{typevar} object. In
case of function for predefined types, it is possible to use ellipsis for
overwriting default values (see § Examples).}
}
\value{
An object of class \code{type} and \code{typevar}, where \code{type} is the value of the
argument \code{type} passed to \code{type_custom}, or predefined lables (if not
overwritten) in case of other functions.
}
\description{
All functions permit fully-customised types of variable to be defined.
Functions other than \code{type_custom} already include standard default values
which make the definition of standard variable types easier and quicker.
}
\examples{
# Define a new type of real variable where the first parameter of the
# sampling distribution is updated through the median (instead of the
# mean):
type_real(
  type = 'real2', 
  x2v = function(x) { c(median(x), sd(x)) }
)

# Define a new type of real variable whith different smoothing
# parameters:
type_real(
  type = 'real3', 
  smooth = list(
    quote(smooth_lin(x, xt, 0.8)),
    quote(smooth_dec(x, xt, 0.99, 15))
  )
)

}
