% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rnonRLII}
\alias{rnonRLII}
\title{Type II Non-Random Labeling of a Given Set of Points}
\usage{
rnonRLII(
  dat,
  k,
  rho,
  pow,
  init.prop,
  ult.prop,
  rand.init = TRUE,
  poisson = FALSE
)
}
\arguments{
\item{dat}{A set of points the non-RL procedure is applied to obtain cases and controls randomly in the 
type II fashion (see the description).}

\item{k}{An integer representing the number of NNs considered for each contagious case, i.e., 
\code{k}NNs of each contagious case are candidates to be infected to become cases.}

\item{rho}{A scaling parameter for the probabilities of labeling the points as cases
(see the description).}

\item{pow}{A parameter in the power adjusting the \code{k}NN dependence in the probabilities of labeling the
points as cases (see the description).}

\item{init.prop}{A real number between 0 and 1 representing the initial proportion of cases in the data set,
\code{dat}. The selection of the initial cases depends on the parameter \code{rand.init} (see the description).}

\item{ult.prop}{A real number between 0 and 1 representing the ultimate proportion of cases in the data set,
\code{dat} after the non-RL assignment.}

\item{rand.init}{A logical argument (default is \code{TRUE}) to determine the choice of the initial cases in the data set, \code{dat}.
If \code{rand.init=TRUE} then the initial cases are selected randomly from the data points, and if \code{rand.init=}
\code{FALSE}, the first \code{init.prop*n} entries in the data set, \code{dat}, are labeled as the cases.}

\item{poisson}{A logical argument (default is \code{FALSE}) to determine whether the number of initial and ultimate
cases, \eqn{k_0} and \eqn{n_1}, will be random or fixed. If \code{poisson=TRUE} then the \eqn{k_0} and \eqn{n_1} are from a Poisson distribution,
\eqn{k_0=}\code{rpois(1,round(n*init.prop,0)}) and \eqn{n_1=}\code{rpois(1,round(n*ult.prop,0))}
otherwise they are fixed, \eqn{k_0=}\code{round(n*init.prop,0)} and \eqn{n_1=}\code{round(n*ult.prop,0)}.}
}
\value{
A \code{list} with the elements
\item{pat.type}{\code{="cc"} for the case-control patterns for RL or non-RL of the given data points, \code{dat}}
\item{type}{The type of the point pattern}
\item{parameters}{Number of NNs, \code{k}, a scaling parameter for the infection probabilities of \code{k}NNs, rho,
a parameter in the power adjusting the \code{k}NN dependence of the infection probabilities, initial proportion
of cases, \code{init.prop}, and the ultimate proportion of cases, \code{ult.prop}.}
\item{dat.points}{The set of points non-RL procedure is applied to obtain cases and controls randomly in the 
type II fashion}
\item{lab}{The labels of the points as 1 for cases and 0 for controls after the type II nonRL procedure is
applied to the data set, \code{dat}. Cases are denoted as red dots and controls as black circles in the plot.}
\item{init.cases}{The initial cases in the data set, \code{dat}. Denoted as red crosses in the plot of the points.}
\item{cont.cases}{The contagious cases in the data set, \code{dat}. Denoted as blue points in the plot of the points.}
\item{gen.points,ref.points}{Both are \code{NULL} for this function, as initial set of points, \code{dat}, are provided
for the non-RL procedure.}
\item{desc.pat}{Description of the point pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The \code{vector} of two numbers, which are the number of cases and controls.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated and the reference points}
}
\description{
An object of class \code{"SpatPatterns"}.

Given the set of \eqn{n} points, \code{dat}, in a region, this function assigns \eqn{n_1=}\code{round(n*ult.prop,0)} of them as cases,
and the rest as controls with first selecting \eqn{k_0=}\code{round(n*init.prop,0)} as cases initially, then selecting
a contagious case and then assigning the label case to the remaining points with infection probabilities 
inversely proportional to their position among the \code{k}NNs.

The initial and ultimate number of cases will be \eqn{k_0} and \eqn{n_1} on the average if the argument \code{poisson=TRUE}
(i.e., \eqn{k_0=}\code{rpois(1,round(n*init.prop,0)}) and \eqn{n_1=}\code{rpois(1,round(n*ult.prop,0))} ), otherwise
they will be exactly equal to \eqn{n_1=}\code{round(n*ult.prop,0)} and \eqn{k_0=}\code{round(n*init.prop,0)}.
More specifically, let \eqn{z_1,\ldots,z_{k_0}} be the initial cases. Then one of the cases is selected as a
contagious case, say \eqn{z_j} and then its \code{k}NNs (among the non-cases) are found.
Then label these \code{k}NN non-case points as cases with infection probabilities \code{prob} equal to the value
of the \code{rho*(1/(1:k))^pow} values at these points, where \code{rho} is a scaling parameter for
the infection probabilities and \code{pow} is a parameter in the power adjusting the \code{k}NN dependence.
We stop when we first exceed \eqn{n_1} cases. \code{rho} has to be in \eqn{(0,1)} for \code{prob} to be a \code{vector} of probabilities,
and for a given \code{rho}, \code{pow} must be \eqn{>  \ln(rho)/\ln(k)}.
If \code{rand.init=TRUE}, first \eqn{k_0} entries are chosen as the initial cases in the data set,
\code{dat}, otherwise, \eqn{k_0} initial cases are selected randomly among the data points.

Algorithmically, first all dat points are treated as non-cases (i.e., controls or healthy subjects).
Then the function follows the following steps for labeling of the points: 

step 0: \eqn{n_1} is generated randomly from a Poisson distribution with \code{mean = round(n*ult.prop,0)}, so that the 
average number of ultimate cases will be \code{round(n*ult.prop,0)} if the argument \code{poisson=TRUE}, else \eqn{n_1=}\code{round(n*ult.prop,0)}.
And \eqn{k_0} is generated randomly from a Poisson distribution with \code{mean = round(n*init.prop,0)}, so that the 
average number of initial cases will be \code{round(n*init.prop,0)} if the argument \code{poisson=TRUE}, else \eqn{k_0=}\code{round(n*init.prop,0)}.

step 1: Initially, \eqn{k_0} many points from dat are selected as cases.
The selection of initial cases are determined based on the argument \code{rand.init} (with default=\code{TRUE})
where if \code{rand.init=TRUE} then the initial cases are selected randomly from the data points, and if \code{rand.init=}
\code{FALSE}, the first \eqn{k_0} entries in the data set, \code{dat}, are selected as the cases.

step 2: Then it selects a contagious case among the cases, and randomly labels its \code{k} control NNs as cases with
decreasing infection probabilities \code{prob=rho*(1/(1:k))^pow}. See the description for the details
of the parameters in the \code{prob}.

step 3: The procedure ends when number of cases \eqn{n_c} exceeds \eqn{n_1}, and \eqn{n_c-n_1} of the cases (other than the
initial cases) are randomly selected and relabeled as controls, i.e., 0s,
so that the number of cases is exactly \eqn{n_1}.

Note that the infection probabilities of the \code{k}NNs of each initial case increase
with increasing rho; and probability of infection decreases as further NNs are considered from 
a contagious case (i.e., as \code{k} increases in the \code{k}NNs).

See \insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat} for more detail where type II non-RL pattern is the 
case 2 of non-RL pattern considered in Section 6 with \eqn{n_1} is
fixed as a parameter rather than being generated from a Poisson distribution and \code{pow=1}.

Although the non-RL pattern is described for the case-control setting, it can be adapted for any two-class
setting when it is appropriate to treat one of the classes as cases or one of the classes behave like cases
and other class as controls.
}
\examples{
n<-40;  #try also n<-20; n<-100;
#data generation
dat<-cbind(runif(n,0,1),runif(n,0,1))

rho<-.8
pow<-2
knn<-5 #try 2 or 3
ip<-.3 #initial proportion
up<-.5 #ultimate proportion

Xdat<-rnonRLII(dat,knn,rho,pow,ip,up,poisson=FALSE) #labeled data, try poisson=TRUE
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#normal original data
n<-40;  #try also n<-20; n<-100;
#data generation
dat<-cbind(rnorm(n,0,1),rnorm(n,0,1))

rho<-0.8
pow<-2
knn<-5 #try 2 or 3
ip<-.3 #initial proportion
up<-.5 #ultimate proportion

Xdat<-rnonRLII(dat,knn,rho,pow,ip,up,poisson=FALSE) #labeled data, try poisson=TRUE
Xdat

table(Xdat$lab)

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rnonRLI}}, \code{\link{rnonRLIII}}, \code{\link{rnonRLIV}}, and \code{\link{rnonRL}}
}
\author{
Elvan Ceyhan
}
