% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{Xsq.ceTk}
\alias{Xsq.ceTk}
\title{Chi-square Approximation to Cuzick and Edwards \eqn{T_k} Test statistic}
\usage{
Xsq.ceTk(
  dat,
  cc.lab,
  k,
  case.lab = NULL,
  nonzero.mat = TRUE,
  asy.var = FALSE,
  ...
)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{cc.lab}{Case-control labels, 1 for case, 0 for control}

\item{k}{Integer specifying the number of NNs (of subject \eqn{i}).}

\item{case.lab}{The label used for cases in the \code{cc.lab} (if \code{cc.lab} is not provided then the labels are converted
such that cases are 1 and controls are 0), default is \code{NULL}.}

\item{nonzero.mat}{A logical argument (default is \code{TRUE}) to determine whether the \eqn{A} matrix or the matrix of
nonzero locations of the \eqn{A} matrix will be used in the computations.
If \code{TRUE} the nonzero location matrix is used, otherwise the \eqn{A} matrix itself is used.}

\item{asy.var}{A logical argument (default is \code{FALSE}) to determine whether the asymptotic variance or 
the exact (i.e., finite sample) variance for the variance of \eqn{T_k} in its standardization. 
If \code{TRUE}, the asymptotic variance is used for \eqn{Var[T_k]}, otherwise the exact variance is used.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
A \code{list} with the elements
\item{statistic}{The chi-squared test statistic for Tango's chi-square approximation to Cuzick & Edwards' \eqn{T_k}
test for disease clustering.}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{8/}skewness where skewness is the output of
\code{\link{SkewTk}} function.}
\item{estimate}{Estimates, i.e., the observed \eqn{T_k} value.}
\item{est.name,est.name2}{Names of the estimates, they are almost identical for this function.}
\item{null.value}{Hypothesized null value for Cuzick & Edwards' \eqn{T_k}, which is \eqn{ET_k}.}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set, \code{dat}}
}
\description{
An object of class \code{"Chisqtest"} performing  a chi-square approximation for Cuzick and Edwards \eqn{T_k} test statistic
based on the number of cases within \code{k}NNs of the cases in the data.

This approximation is suggested by \insertCite{tango:2007;textual}{nnspat} since \eqn{T_k} statistic had high 
skewness rendering the normal approximation less efficient. The chi-square approximation is as follows:
\eqn{\frac{T_k- ET_k}{\sqrt{Var T_k}} \approx \frac{\chi^2_\nu-\nu}{\sqrt{2 \nu}}} where \eqn{\chi^2_\nu} is a chi-square
random variable with \eqn{\nu} df, and \eqn{\nu=8/skewnees(T_k)} (see \code{\link{SkewTk}} for the skewness).

The argument \code{cc.lab} is case-control label, 1 for case, 0 for control, if the argument \code{case.lab} is \code{NULL}, 
then \code{cc.lab} should be provided in this fashion, if \code{case.lab} is provided, the labels are converted to 0's 
and 1's accordingly.

The logical argument \code{nonzero.mat} (default=\code{FALSE}) is for using the \eqn{A} matrix if \code{FALSE} or just the matrix of nonzero
locations in the \eqn{A} matrix (if \code{TRUE}).

The logical argument \code{asy.var} (default=\code{FALSE}) is for using the asymptotic variance or the exact (i.e., finite
sample) variance for the variance of \eqn{T_k} in its standardization.
If \code{asy.var=TRUE}, the asymptotic variance is used for \eqn{Var[T_k]} (see \code{asyvarTk}), otherwise the exact
variance (see \code{varTk}) is used.

See also (\insertCite{tango:2007;textual}{nnspat}) and the references therein.
}
\examples{
set.seed(123)
n<-20
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)

k<-sample(1:5,1) # try also 1, 3, 5,
k

Xsq.ceTk(Y,cls,k)
Xsq.ceTk(Y,cls,k,nonzero.mat=FALSE)
Xsq.ceTk(Y,cls+1,k,case.lab = 2)
Xsq.ceTk(Y,cls,k,method="max")

Xsq.ceTk(Y,cls,k,asy.var=TRUE)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTk}}, \code{\link{ZceTk}} and \code{\link{SkewTk}}
}
\author{
Elvan Ceyhan
}
