% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmslib.R
\name{KernelKnn_nmslib}
\alias{KernelKnn_nmslib}
\title{Approximate Kernel k nearest neighbors using the nmslib library}
\usage{
KernelKnn_nmslib(
  data,
  y,
  TEST_data = NULL,
  k = 5,
  h = 1,
  weights_function = NULL,
  Levels = NULL,
  Index_Params = NULL,
  Time_Params = NULL,
  space = "l1",
  space_params = NULL,
  method = "hnsw",
  data_type = "DENSE_VECTOR",
  dtype = "FLOAT",
  index_filepath = NULL,
  print_progress = FALSE,
  num_threads = 1
)
}
\arguments{
\item{data}{either a matrix or a scipy sparse matrix}

\item{y}{a numeric vector specifying the response variable (in classification the labels must be numeric from 1:Inf). The length of \emph{y} must equal the rows of the \emph{data} parameter}

\item{TEST_data}{a test dataset (in case of a matrix the \emph{TEST_data} should have equal number of columns with the \emph{data}). It is assumed that the \emph{TEST_data} is an unlabeled dataset}

\item{k}{an integer. The number of neighbours to return}

\item{h}{the bandwidth (applicable if the weights_function is not NULL, defaults to 1.0)}

\item{weights_function}{there are various ways of specifying the kernel function. See the details section.}

\item{Levels}{a numeric vector. In case of classification the unique levels of the response variable are necessary}

\item{Index_Params}{a list of (optional) parameters to use in indexing (when creating the index)}

\item{Time_Params}{a list of parameters to use in querying. Setting \emph{Time_Params} to NULL will reset}

\item{space}{a character string (optional). The metric space to create for this index. Page 31 of the manual (see \emph{references}) explains all available inputs}

\item{space_params}{a list of (optional) parameters for configuring the space. See the \emph{references} manual for more details.}

\item{method}{a character string specifying the index method to use}

\item{data_type}{a character string. One of 'DENSE_UINT8_VECTOR', 'DENSE_VECTOR', 'OBJECT_AS_STRING' or 'SPARSE_VECTOR'}

\item{dtype}{a character string. Either 'FLOAT' or 'INT'}

\item{index_filepath}{a character string specifying the path to a file, where an existing index is saved}

\item{print_progress}{a boolean (either TRUE or FALSE). Whether or not to display progress bar}

\item{num_threads}{an integer. The number of threads to use}
}
\description{
Approximate Kernel k nearest neighbors using the nmslib library
}
\details{
There are three possible ways to specify the \emph{weights function}, 1st option : if the weights_function is NULL then a simple k-nearest-neighbor is performed. 2nd option : the weights_function is one of 'uniform', 'triangular', 'epanechnikov', 'biweight', 'triweight', 'tricube', 'gaussian', 'cosine', 'logistic', 'gaussianSimple', 'silverman', 'inverse', 'exponential'. The 2nd option can be extended by combining kernels from the existing ones (adding or multiplying). For instance, I can multiply the tricube with the gaussian kernel by giving 'tricube_gaussian_MULT' or I can add the previously mentioned kernels by giving 'tricube_gaussian_ADD'. 3rd option : a user defined kernel function
}
\examples{

try({
  if (reticulate::py_available(initialize = FALSE)) {
    if (reticulate::py_module_available("nmslib")) {

      library(nmslibR)

      x = matrix(runif(1000), nrow = 100, ncol = 10)

      y = runif(100)

      out = KernelKnn_nmslib(data = x, y = y, k = 5)
    }
  }
}, silent=TRUE)
}
