% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_sens_params.R
\name{sim_sens_3cmpt}
\alias{sim_sens_3cmpt}
\title{Parameter sweeping for a three-compartment pharmacokinetic model}
\usage{
sim_sens_3cmpt(
  dat,
  sim_vc = list(mode = "manual", values = NULL),
  sim_vp = list(mode = c("auto", "manual"), values = NULL),
  sim_vp2 = list(mode = c("auto", "manual"), values = NULL),
  sim_q = list(mode = c("auto", "manual"), values = NULL, auto.strategy = c("scaled",
    "fixed")),
  sim_q2 = list(mode = c("auto", "manual"), values = NULL, auto.strategy = c("scaled",
    "fixed")),
  sim_cl = list(mode = "manual", values = NULL),
  sim_ka = list(mode = "manual", values = NULL),
  route = c("iv", "oral"),
  verbose = TRUE
)
}
\arguments{
\item{dat}{Pharmacokinetic dataset.}

\item{sim_vc}{List specifying Vc:
\itemize{
\item mode: must be "manual"
\item values: numeric vector
}}

\item{sim_vp}{List specifying Vp1:
\itemize{
\item mode: "manual" or "auto"
\item values: numeric vector if manual
}}

\item{sim_vp2}{List specifying Vp2:
\itemize{
\item mode: "manual" or "auto"
\item values: numeric vector if manual
}}

\item{sim_q}{List specifying Q1:
\itemize{
\item mode: "manual" or "auto"
\item values: numeric vector if manual
\item auto.strategy: "scaled" or "fixed" when auto
}}

\item{sim_q2}{List specifying Q2:
\itemize{
\item mode: "manual" or "auto"
\item values: numeric vector if manual
\item auto.strategy: "scaled" or "fixed" when auto
}}

\item{sim_cl}{List specifying CL:
\itemize{
\item mode: must be "manual"
\item values: numeric vector
}}

\item{sim_ka}{List specifying Ka (oral route only):
\itemize{
\item mode: must be "manual"
\item values: numeric vector
}}

\item{route}{Dosing route, either "iv" or "oral". Default is "iv".}

\item{verbose}{Logical (default = TRUE).
Controls whether progress information is displayed during parameter sweeping.
When TRUE, a dynamic progress bar is shown using the \code{progressr} package to
indicate simulation status and elapsed time.
When FALSE, progress output is suppressed and the function runs silently.}
}
\value{
A data frame containing parameter combinations with model fit metrics.
}
\description{
Performs parameter sweeping by varying pharmacokinetic parameters in a
three-compartment model under IV or oral dosing. Parameter combinations
include Vc, Vp1, Vp2, Q1, Q2, CL, and Ka (oral only).
}
\details{
The function generates a parameter grid and evaluates each combination
using \code{Fit_3cmpt_iv} or \code{Fit_3cmpt_oral}. Model predictions and fit metrics
are calculated for each simulation to assess parameter influence and
identify optimal regions of the parameter space. Parameters can be provided
manually or derived automatically.
}
\examples{
\donttest{
out <- sim_sens_3cmpt(
  dat = Bolus_2CPT,
  sim_cl = list(mode = "manual", values = 4),
  sim_vc = list(mode = "manual", values = 50),
  sim_vp = list(mode = "auto"),
  sim_vp2 = list(mode = "auto"),
  sim_q  = list(mode = "auto", auto.strategy = "scaled"),
  sim_q2 = list(mode = "auto", auto.strategy = "scaled"),
  route = "iv",verbose=FALSE
)
head(out[out$rRMSE2==min(out$rRMSE2),])
}

}
\seealso{
\code{\link{Fit_3cmpt_iv}}, \code{\link{Fit_3cmpt_oral}}
}
\author{
Zhonghui Huang
}
