% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npd_modelcodes.R
\name{Fit_2cmpt_iv}
\alias{Fit_2cmpt_iv}
\title{Fit intravenous pharmacokinetic data to a two-compartment linear elimination model}
\usage{
Fit_2cmpt_iv(
  data,
  est.method,
  input.cl,
  input.vc2cmpt,
  input.vp2cmpt,
  input.q2cmpt,
  input.add,
  return.pred.only = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame containing IV pharmacokinetic data formatted for nlmixr2,}

\item{est.method}{Estimation method to use in nlmixr2. Must be one of:
\code{"rxSolve"}, \code{"nls"}, \code{"nlm"}, \code{"nlminb"}, or \code{"focei"}.}

\item{input.cl}{Initial estimate of clearance (CL).}

\item{input.vc2cmpt}{Initial estimate of central volume of distribution (V1).}

\item{input.vp2cmpt}{Initial estimate of peripheral volume of distribution (V2).}

\item{input.q2cmpt}{Initial estimate of inter-compartmental clearance (Q).}

\item{input.add}{Initial estimate of the additive residual error.}

\item{return.pred.only}{Logical; if \code{TRUE}, returns a data frame with
only predicted concentrations (\code{cp}) for all observations in the input data.}

\item{...}{Additional arguments passed to \code{nlmixr2()}, such as a user-defined
\code{control = foceiControl(...)} or other control settings.}
}
\value{
If \code{return.pred.only = TRUE}, returns a \code{data.frame}
with a single column \code{cp} (predicted concentrations).
Otherwise, returns a fitted model object produced by nlmixr2.
}
\description{
Fits intravenous (IV) pharmacokinetic data to a two-compartment model with
first-order elimination using the naive pooled data approach. Supports
multiple estimation methods provided by nlmixr2 and can optionally return
only predicted concentrations to support efficient simulation workflows.
}
\examples{
 \donttest{
dat <- Bolus_2CPT
# Fit using 'nls'
Fit_2cmpt_iv(
  data = dat,
  est.method = "nls",
  input.cl = 4,
  input.vc2cmpt = 70,
  input.vp2cmpt = 40,
  input.q2cmpt = 4,
  input.add = 10
)
# Return only predicted concentrations
Fit_2cmpt_iv(
  data = dat,
  est.method = "rxSolve",
  input.cl = 4,
  input.vc2cmpt = 70,
  input.vp2cmpt = 40,
  input.q2cmpt = 4,
  input.add = 0,
  return.pred.only = TRUE
)
}

}
\author{
Zhonghui Huang
}
